% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowFrame-accessors.R
\docType{methods}
\name{filter-methods}
\alias{filter-methods}
\alias{filter}
\alias{filter-method}
\alias{filter,flowFrame-method}
\alias{filter,flowFrame,filter-method}
\alias{filter,flowFrame,rectangleGate}
\alias{filter,flowFrame,polygonGate}
\alias{filter,flowFrame,norm2Filter}
\alias{filter,flowSet,filter-method}
\alias{filter,flowSet,list-method}
\alias{filter,flowSet,filterList-method}
\alias{summary,filter-method}
\alias{show,filter-method}
\alias{length,filter-method}
\alias{formula,filter-method}
\alias{character,filter-method}
\alias{name,filter-method}
\alias{call,filter-method}
\alias{identifier<-,filter,character-method}
\title{Filter FCS files}
\usage{
filter(x, filter, method = c("convolution", "recursive"), 
sides = 2L, circular = FALSE, init = NULL)
}
\arguments{
\item{x}{Object of class \code{\linkS4class{flowFrame}} or
\code{\linkS4class{flowSet}}.}

\item{filter}{An object of class \code{\linkS4class{filter}} or a named list
\code{filters}.}

\item{method, sides, circular, init}{These arguments are not used.}
}
\value{
A \code{\linkS4class{filterResult}} object or a
\code{\linkS4class{filterResultList}} object if \code{x} is a
\code{\linkS4class{flowSet}}. Note that \code{\linkS4class{filterResult}}
objects are themselves filters, allowing them to be used in filter
expressions or \code{Subset} operations.
}
\description{
These methods link filter descriptions to a particular set of flow cytometry
data allowing for the lightweight calculation of summary statistics common
to flow cytometry analysis.
}
\details{
The \code{filter} method conceptually links a filter description,
represented by a \code{\linkS4class{filter}} object, to a particular
\code{\linkS4class{flowFrame}}. This is accomplished via the
\code{\linkS4class{filterResult}} object, which tracks the linked frame as
well as caching the results of the filtering operation itself, allowing for
fast calculation of certain summary statistics such as the percentage of
events accepted by the \code{filter}. This method exists chiefly to allow
the calculation of these statistics without the need to first
\code{\link{Subset}} a \code{\linkS4class{flowFrame}}, which can be quite
large.

When applying on a \code{flowSet}, the \code{filter} argument can either be
a single \code{filter} object, in which case it is recycled for all frames
in the set, or a named list of \code{filter} objects. The names are supposed
to match the frame identifiers (i.e., the output of \code{sampleNames(x)} of
the \code{flowSet}. If some frames identifiers are missing, the particular
frames are skipped during filtering. Accordingly, all \code{filters} in the
filter list that can't be mapped to the \code{flowSet} are ignored. Note
that all \code{filter} objects in the list must be of the same type, e.g.
\code{rectangleGates}.
}
\examples{

## Filtering a flowFrame
samp <- read.FCS(system.file("extdata","0877408774.B08", package="flowCore"))
rectGate <- rectangleGate(filterId="nonDebris","FSC-H"=c(200,Inf))
fr <- filter(samp,rectGate)
class(fr)
summary(fr)

## filtering a flowSet
data(GvHD)
foo <- GvHD[1:3]
fr2 <- filter(foo, rectGate)
class(fr2)
summary(fr2)

## filtering a flowSet using different filters for each frame
rg2 <- rectangleGate(filterId="nonDebris","FSC-H"=c(300,Inf))
rg3 <- rectangleGate(filterId="nonDebris","FSC-H"=c(400,Inf))
flist <- list(rectGate, rg2, rg3)
names(flist) <- sampleNames(foo)
fr3 <- filter(foo, flist)

}
\seealso{
\code{\link{Subset}}, \code{\linkS4class{filter}}, \code{\linkS4class{filterResult}}
}
\author{
F Hahne, B. Ellis, N. Le Meur
}
\keyword{methods}
