% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retFatMatrix.R
\name{retFatMatrix}
\alias{retFatMatrix}
\title{retFatMatrix}
\usage{
retFatMatrix(object, data, minFilter = round(length(object@files)/3 * 2))
}
\arguments{
\item{object}{peakDataset object}

\item{data}{a gatherInfo() object}

\item{minFilter}{the minimum number for a feature to be returned in the data
matrix. Default is 2/3 of the samples}
}
\value{
A fat data matrix containing the area of the deconvoluted and
aligned peaks. The row are the samples while the column represent the
different peaks
}
\description{
Build a fat data matrix
}
\details{
This function allows to extract the data from an object created using
\code{gatherInfo} and build a data matrix using the area of the deconvoluted
and aligned peaks. The row are the samples while the column represent the
different peaks.
}
\examples{

require(gcspikelite)
files <- list.files(path = paste(find.package("gcspikelite"), "data",
                    sep = "/"),"CDF", full = TRUE)
data <- peaksDataset(files[1:2], mz = seq(50, 550), rtrange = c(7.5, 8.5))
## create settings object
mfp <- xcms::MatchedFilterParam(fwhm = 10, snthresh = 5)
cwt <- xcms::CentWaveParam(snthresh = 3, ppm = 3000, peakwidth = c(3, 40),
 prefilter = c(3, 100), fitgauss = FALSE, integrate = 2, noise = 0,
 extendLengthMSW = TRUE, mzCenterFun = "wMean")
data <- addXCMSPeaks(files[1:2], data, settings = mfp)
data
ma <- multipleAlignment(pd = data, group = c(1,1),
                        filterMin = 1, metric = 2, type = 2)
outList <- gatherInfo(data, ma)
mtxD <- retFatMatrix(object = data, data = outList, minFilter = 1)

}
\seealso{
\code{\link{gatherInfo}}
}
\author{
Riccardo Romoli \email{riccardo.romoli@unifi.it}
}
