% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progressiveAlignment.R
\name{progressiveAlignment-class}
\alias{progressiveAlignment-class}
\alias{progressiveAlignment}
\alias{progressiveAlignment-show}
\alias{show,progressiveAlignment-method}
\title{Data Structure for progressive alignment of many GCMS samples}
\usage{
progressiveAlignment(
  pD,
  cA,
  D = 50,
  gap = 0.5,
  verbose = TRUE,
  usePeaks = TRUE,
  df = 30,
  compress = FALSE,
  type = 2
)
}
\arguments{
\item{pD}{a \code{peaksDataset} object}

\item{cA}{a \code{clusterAlignment} object}

\item{D}{retention time penalty}

\item{gap}{gap parameter}

\item{verbose}{logical, whether to print information}

\item{usePeaks}{logical, whether to use peaks (if \code{TRUE}) or the full
2D profile alignment (if \code{FALSE})}

\item{df}{distance from diagonal to calculate similarity}

\item{compress}{logical, whether to store the similarity matrices in sparse
form}

\item{type}{numeric, two different type of alignment function}
}
\value{
\code{progressiveAlignment} object
}
\description{
Performs a progressive peak alignment (clustalw style) of multiple GCMS peak
lists
}
\details{
The progressive peak alignment we implemented here for multiple GCMS peak
lists is analogous to how \code{clustalw} takes a set of pairwise sequence
alignments and progressively builds a multiple alignment.  More details can
be found in the reference below.
}
\examples{

require(gcspikelite)
files <- list.files(path = paste(find.package("gcspikelite"), "data",
                    sep = "/"),"CDF", full = TRUE)
data <- peaksDataset(files[1:2], mz = seq(50, 550), rtrange = c(7.5, 8.5))
## create settings object
mfp <- xcms::MatchedFilterParam(fwhm = 10, snthresh = 5)
cwt <- xcms::CentWaveParam(snthresh = 3, ppm = 3000, peakwidth = c(3, 40),
 prefilter = c(3, 100), fitgauss = FALSE, integrate = 2, noise = 0,
 extendLengthMSW = TRUE, mzCenterFun = "wMean")
data <- addXCMSPeaks(files[1:2], data, settings = mfp)
data
ca <- clusterAlignment(data, gap = 0.5, D = 0.05, df = 30, metric = 1,
  type = 1, compress = FALSE)
pa <- progressiveAlignment(data, ca, gap = 0.6, D = 0.1, df = 30,
 type = 1, compress = FALSE)

}
\references{
Mark D Robinson (2008).  Methods for the analysis of gas
chromatography - mass spectrometry data \emph{PhD dissertation} University
of Melbourne.
}
\seealso{
\code{\link{peaksDataset}}, \code{\link{multipleAlignment}}
}
\author{
Mark Robinson
}
\keyword{classes}
