% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaksDataset.R
\name{plotChrom,peaksDataset-method}
\alias{plotChrom,peaksDataset-method}
\title{Plotting functions for GCMS data objects}
\usage{
\S4method{plotChrom}{peaksDataset}(
  object,
  runs = 1:length(object@rawdata),
  mzind = 1:nrow(object@rawdata[[1]]),
  mind = NULL,
  plotSampleLabels = TRUE,
  calcGlobalMax = FALSE,
  peakCex = 0.8,
  plotPeaks = TRUE,
  plotPeakBoundaries = FALSE,
  plotPeakLabels = FALSE,
  plotMergedPeakLabels = TRUE,
  mlwd = 3,
  usePeaks = TRUE,
  plotAcrossRuns = FALSE,
  overlap = F,
  rtrange = NULL,
  cols = NULL,
  thin = 1,
  max.near = median(object@rawrt[[1]]),
  how.near = 50,
  scale.up = 1,
  ...
)
}
\arguments{
\item{object}{a \code{peaksDataset} object.}

\item{runs}{set of run indices to plot}

\item{mzind}{set of mass-to-charge indices to sum over (default, all)}

\item{mind}{matrix of aligned indices}

\item{plotSampleLabels}{logical, whether to display sample labels}

\item{calcGlobalMax}{logical, whether to calculate an overall maximum
for scaling}

\item{peakCex}{character expansion factor for peak labels}

\item{plotPeaks}{logical, whether to plot hashes for each peak}

\item{plotPeakBoundaries}{logical, whether to display peak boundaries}

\item{plotPeakLabels}{logical, whether to display peak labels}

\item{plotMergedPeakLabels}{logical, whether to display 'merged' peak
labels}

\item{mlwd}{line width of lines indicating the alignment}

\item{usePeaks}{logical, whether to plot  alignment of peaks
(otherwise, scans)}

\item{plotAcrossRuns}{logical, whether to plot across peaks when
unmatched peak is given}

\item{overlap}{logical, whether to plot TIC/XICs overlapping}

\item{rtrange}{vector of length 2 giving start  and end of the X-axis}

\item{cols}{vector of colours (same length as the length of runs)}

\item{thin}{when \code{usePeaks=FALSE}, plot  the alignment lines
every \code{thin} values}

\item{max.near}{where to look for maximum}

\item{how.near}{how far away from \code{max.near} to look}

\item{scale.up}{a constant factor to scale the TICs}

\item{...}{further arguments passed to the \code{plot}}
}
\value{
plot the chromatograms
}
\description{
Store the raw data and optionally, information regarding signal peaks for a
number of GCMS runs
}
\details{
Each TIC is scale to the maximum value (as specified by the
\code{how.near} and \code{max.near} values). The many parameters gives
considerable flexibility of how the TICs can be visualized.
}
\examples{

require(gcspikelite)

## paths and files
gcmsPath <- paste(find.package("gcspikelite"), "data", sep="/")
cdfFiles <- dir(gcmsPath, "CDF", full=TRUE)
eluFiles <- dir(gcmsPath, "ELU", full=TRUE)

## read data
pd <- peaksDataset(cdfFiles[1:3], mz=seq(50,550), rtrange=c(7.5,8.5))

## image plot
plotChrom(pd, rtrange = c(7.5,8.5), plotPeaks = TRUE,
          plotPeakLabels = TRUE)
}
\references{
Mark D Robinson (2008).  Methods for the analysis of gas
chromatography - mass spectrometry data \emph{PhD dissertation} University
of Melbourne.
}
\seealso{
\code{\link{peaksDataset}}
}
\author{
Mark Robinson
}
\keyword{classes}
