% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaksAlignment.R
\name{peaksAlignment-class}
\alias{peaksAlignment-class}
\alias{peaksAlignment}
\alias{peaksAlignment-show}
\alias{peaksAlignment-plot}
\alias{show,peaksAlignment-method}
\alias{plot,peaksAlignment-method}
\alias{plot,peaksAlignment,ANY-method}
\title{Data Structure for pairwise alignment of 2 GCMS samples}
\usage{
peaksAlignment(
  d1,
  d2,
  t1,
  t2,
  gap = 0.5,
  D = 50,
  timedf = NULL,
  df = 30,
  verbose = TRUE,
  usePeaks = TRUE,
  compress = TRUE,
  metric = 2,
  type = 2,
  penality = 0.2
)
}
\arguments{
\item{d1}{matrix of MS intensities for 1st sample (if doing a peak
alignment, this contains peak apexes/areas; if doing a profile alignment,
this contains scan intensities.  Rows are m/z bins, columns are
peaks/scans.}

\item{d2}{matrix of MS intensities for 2nd sample}

\item{t1}{vector of retention times for 1st sample}

\item{t2}{vector of retention times for 2nd sample}

\item{gap}{gap penalty for dynamic programming algorithm. Not used if
\code{type=2}}

\item{D}{time window (on same scale as retention time differences,
\code{t1}
and \code{t2}. Default scale is seconds.)}

\item{timedf}{list (length = the number of pairwise alignments) of matrices
giving the expected time differences expected at each pair of peaks used
with \code{usePeaks}=\code{TRUE}.}

\item{df}{integer, how far from the diagonal to go to calculate the
similarity of peaks. Smaller value should run faster, but be careful not to
choose too low.}

\item{verbose}{logical, whether to print out info.}

\item{usePeaks}{logical, \code{TRUE} uses \code{peakdata} list,
\code{FALSE}
uses \code{rawdata} list for computing similarity.}

\item{compress}{logical, whether to compress the similarity matrix into a
sparse format.}

\item{metric}{numeric, different algorithm to calculate the similarity
matrix between two mass spectrum. \code{metric=1} call
\code{normDotProduct()}; \code{metric=2} call \code{ndpRT()};
\code{metric=3} call \code{corPrt()}}

\item{type}{numeric, two different type of alignment function}

\item{penality}{penalization applied to the matching between two mass
spectra if \code{(t1-t2)>D}}
}
\value{
\code{peaksAlignment} object
}
\description{
Store the raw data and optionally, information regarding signal peaks for a
number of GCMS runs
}
\details{
peaksAlignment is a hold-all data structure of the raw and peak detection
data.
}
\examples{

## see clusterAlignment, it calls peaksAlignment

## Not Run:
files <- list.files(path = paste(find.package("gcspikelite"), "data",
                    sep = "/"),"CDF", full = TRUE)
data <- peaksDataset(files[1:2], mz = seq(50, 550), rtrange = c(7.5, 8.5))
## create settings object
mfp <- xcms::MatchedFilterParam(fwhm = 10, snthresh = 5)
cwt <- xcms::CentWaveParam(snthresh = 3, ppm = 3000, peakwidth = c(3, 40),
 prefilter = c(3, 100), fitgauss = FALSE, integrate = 2, noise = 0,
 extendLengthMSW = TRUE, mzCenterFun = "wMean")
data <- addXCMSPeaks(files[1:2], data, settings = mfp)
data
plotChrom(data, rtrange=c(7.5, 10.5), runs=c(1:2))

## align two chromatogram
pA <- peaksAlignment(data@peaksdata[[1]], data@peaksdata[[2]],
                     data@peaksrt[[1]], data@peaksrt[[2]], D = 50,
                     metric = 3, compress = FALSE, type = 2, penality = 0.2)

plotAlignment(pA)
pA@v$match

par(mfrow=c(2,1))
plot(data@peaksdata[[1]][,15], type = 'h', main = paste(data@peaksrt[[1]][[15]]))
plot(data@peaksdata[[2]][,17], type = 'h',
     main = paste(data@peaksrt[[2]][[17]]))
## End (Not Run)

}
\references{
Mark D Robinson (2008).  Methods for the analysis of gas
chromatography - mass spectrometry data \emph{PhD dissertation} University
of Melbourne.
}
\seealso{
\code{\link{peaksDataset}}, \code{\link{clusterAlignment}}
}
\author{
Mark Robinson, Riccardo Romoli
}
\keyword{classes}
