% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{ndpRT}
\alias{ndpRT}
\title{Retention Time Penalized Normalized Dot Product}
\usage{
ndpRT(s1, s2, t1, t2, D)
}
\arguments{
\item{s1}{data matrix for sample 1}

\item{s2}{data matrix for sample 2}

\item{t1}{vector of retention times for sample 1}

\item{t2}{vector of retention times for sample 2}

\item{D}{retention time window for the matching}
}
\value{
matrix of similarities
}
\description{
This function calculates the similarity of all pairs of peaks from 2
samples, using the spectra similarity and the retention time differencies
}
\details{
Computes the normalized dot product between every pair of peak vectors in
the retention time window (\code{D})and returns a similarity matrix.
}
\examples{

## Not Run
require(gcspikelite)
files <- list.files(path = paste(find.package("gcspikelite"), "data",
                    sep = "/"),"CDF", full = TRUE)
data <- peaksDataset(files[1:2], mz = seq(50, 550), rtrange = c(7.5, 8.5))
## create settings object
mfp <- xcms::MatchedFilterParam(fwhm = 10, snthresh = 5)
cwt <- xcms::CentWaveParam()
data <- addXCMSPeaks(files[1:2], data, settings = mfp, multipleMF = FALSE)
data
## review peak picking
plotChrom(data, rtrange = c(7.5, 10.5), runs = c(1:2))

r <- ndpRT(data@peaksdata[[1]], data@peaksdata[[2]],
           data@peaksrt[[1]], data@peaksrt[[2]], D = 50)
## End (Not Run)

}
\seealso{
\code{\link{peaksAlignment}}
}
\author{
Riccardo Romoli
}
\keyword{manip}
