% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgsea.R
\name{fgseaSimple}
\alias{fgseaSimple}
\title{Runs preranked gene set enrichment analysis.}
\usage{
fgseaSimple(
  pathways,
  stats,
  nperm,
  minSize = 1,
  maxSize = length(stats) - 1,
  scoreType = c("std", "pos", "neg"),
  nproc = 0,
  gseaParam = 1,
  BPPARAM = NULL
)
}
\arguments{
\item{pathways}{List of gene sets to check.}

\item{stats}{Named vector of gene-level stats. Names should be the same as in 'pathways'}

\item{nperm}{Number of permutations to do. Minimial possible nominal p-value is about 1/nperm}

\item{minSize}{Minimal size of a gene set to test. All pathways below the threshold are excluded.}

\item{maxSize}{Maximal size of a gene set to test. All pathways above the threshold are excluded.}

\item{scoreType}{This parameter defines the GSEA score type.
Possible options are ("std", "pos", "neg").
By default ("std") the enrichment score is computed as in the original GSEA.
The "pos" and "neg" score types are intended to be used for one-tailed tests
(i.e. when one is interested only in positive ("pos") or negateive ("neg") enrichment).}

\item{nproc}{If not equal to zero sets BPPARAM to use nproc workers (default = 0).}

\item{gseaParam}{GSEA parameter value, all gene-level statis are raised to the power of `gseaParam`
before calculation of GSEA enrichment scores.}

\item{BPPARAM}{Parallelization parameter used in bplapply.
Can be used to specify cluster to run. If not initialized explicitly or
by setting `nproc` default value `bpparam()` is used.}
}
\value{
A table with GSEA results. Each row corresponds to a tested pathway.
The columns are the following:
\itemize{
 \item pathway -- name of the pathway as in `names(pathway)`;
 \item pval -- an enrichment p-value;
 \item padj -- a BH-adjusted p-value;
 \item ES -- enrichment score, same as in Broad GSEA implementation;
 \item NES -- enrichment score normalized to mean enrichment of random samples of the same size;
 \item nMoreExtreme` -- a number of times a random gene set had a more
     extreme enrichment score value;
 \item size -- size of the pathway after removing genes not present in `names(stats)`.
 \item leadingEdge -- vector with indexes of leading edge genes that drive the enrichment, see \url{http://software.broadinstitute.org/gsea/doc/GSEAUserGuideTEXT.htm#_Running_a_Leading}.
}
}
\description{
The function takes about \emph{O(nk^\{3/2\})} time,
where \emph{n} is number of permutations and \emph{k} is a maximal
size of the pathways. That means that setting `maxSize` parameter with a value of ~500
is strongly recommended.
}
\examples{
data(examplePathways)
data(exampleRanks)
fgseaRes <- fgseaSimple(examplePathways, exampleRanks, nperm=10000, maxSize=500)
# Testing only one pathway is implemented in a more efficient manner
fgseaRes1 <- fgseaSimple(examplePathways[1], exampleRanks, nperm=10000)
}
