% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotEnrichment}
\alias{plotEnrichment}
\title{Plots GSEA enrichment plot. For more flexibility use `plotEnrichmentData` function.}
\usage{
plotEnrichment(pathway, stats, gseaParam = 1, ticksSize = 0.2)
}
\arguments{
\item{pathway}{Gene set to plot.}

\item{stats}{Gene-level statistics.}

\item{gseaParam}{GSEA parameter.}

\item{ticksSize}{width of vertical line corresponding to a gene (default: 0.2)}
}
\value{
ggplot object with the enrichment plot.
}
\description{
Plots GSEA enrichment plot. For more flexibility use `plotEnrichmentData` function.
}
\examples{
data(examplePathways)
data(exampleRanks)
\dontrun{
plotEnrichment(examplePathways[["5991130_Programmed_Cell_Death"]],
               exampleRanks)
}
}
