% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{get_feature_terms}
\alias{get_feature_terms}
\title{Get terms annotating a given feature.}
\usage{
get_feature_terms(term_data, feature_id)
}
\arguments{
\item{term_data}{An object class \code{fenr_terms}, created by
\code{prepare_for_enrichment}.}

\item{feature_id}{A string with a feature ID}
}
\value{
A character vector containing functional term IDs annotating given feature.
}
\description{
Get terms annotating a given feature.
}
\examples{
\dontrun{
go_data <- fetch_go(species = "sgd")
go_terms <- prepare_for_enrichment(go_data$terms, go_data$mapping, feature = "gene_symbol")
trms <- get_feature_terms(go_terms, "GEM1")
}
}
