% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/femap.R
\name{writeFemap}
\alias{writeFemap}
\title{Writes an enrichment dataset file for use in Cytoscape EnrichmentMap.}
\usage{
writeFemap(results, resultsFolder)
}
\arguments{
\item{results}{(list) list with ouput results from \link[fedup]{runFedup}}

\item{resultsFolder}{(char) name of folder to store result file(s)}
}
\value{
Table of pathway enrichment and depletion results formatted as a
'Generic results file'. Rows represent tested pathways. Columns represent:
\itemize{
    \item pathway -- pathway ID (must match pathway IDs in the GMT file
        provided to \link[fedup]{plotFemap};
    \item description -- pathway name or description;
    \item pvalue -- enrichment pvalue;
    \item qvalue -- BH-corrected pvalue;
    \item status -- +1 or -1, to identify enriched or depleted pathways
        (+1 maps to red, -1 maps to blue)
}
}
\description{
Writes an enrichment dataset file for use in Cytoscape EnrichmentMap.
}
\examples{
# Load example data
data(geneDouble)
data(pathwaysGMT)
# Run fedup
fedupRes <- runFedup(geneDouble, pathwaysGMT)
# Write out results to temp folder
resultsFolder <- tempdir()
writeFemap(fedupRes, resultsFolder)
}
