% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period.R
\name{faers_before_period}
\alias{faers_before_period}
\title{Test whether years and quarters are before specified period}
\usage{
faers_before_period(years, quarters, y, q, inclusive = TRUE)
}
\arguments{
\item{years}{An atomic integer indicates years to test.}

\item{quarters}{An atomic character indicates quarters to test, only "q1",
"q2", "q3", and "q4" are allowed.}

\item{y}{An integer, specifying the period year.}

\item{q}{A string, specifying the period quarter.}

\item{inclusive}{A bool, whether to include the period specifid.}
}
\value{
An atomic logical with the same length of the max length of \code{years}
and \code{quarters}.
}
\description{
Test whether years and quarters are before specified period
}
\examples{
faers_before_period(c(2011, 2012), c("q1", "q3"), 2011, "q2")
}
