% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faers.R
\name{faers}
\alias{faers}
\title{Download and parse FAERS Quarterly Data files}
\usage{
faers(
  years,
  quarters,
  format = NULL,
  dir = getwd(),
  compress_dir = dir,
  handle_opts = list()
)
}
\arguments{
\item{years}{An atomic integer indicates years for which data are required.}

\item{quarters}{An atomic character, only "q1", "q2", "q3", and "q4" are
allowed.}

\item{format}{File format to used, only "ascii" and "xml" are availabe.
Default: "ascii".}

\item{dir}{The destination directory for any downloads. Defaults to
current working dir.}

\item{compress_dir}{A string specifies the directory to extract files to. It
will be created if necessary.}

\item{handle_opts}{Extra handle options passed to each request
\link[curl:handle]{new_handle}.}
}
\value{
A \link{FAERSxml} or \link{FAERSascii} object.
}
\description{
Download and parse FAERS Quarterly Data files
}
\examples{
# you must change `dir`, as the file included in the package is sampled
data <- faers(2004, "q1",
    dir = system.file("extdata", package = "faers"),
    compress_dir = tempdir()
)
}
