% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meddra.R
\docType{class}
\name{MedDRA-class}
\alias{MedDRA-class}
\alias{MedDRA}
\alias{meddra}
\alias{show,MedDRA-method}
\alias{meddra_hierarchy}
\alias{meddra_hierarchy,MedDRA-method}
\alias{meddra_smq}
\alias{meddra_smq,MedDRA-method}
\alias{meddra_version}
\alias{meddra_version,MedDRA-method}
\title{MedDRA class}
\usage{
meddra(path, add_smq = FALSE, primary_soc = FALSE)

\S4method{show}{MedDRA}(object)

meddra_hierarchy(object, ...)

\S4method{meddra_hierarchy}{MedDRA}(object)

meddra_smq(object, ...)

\S4method{meddra_smq}{MedDRA}(object)

meddra_version(object, ...)

\S4method{meddra_version}{MedDRA}(object)
}
\arguments{
\item{path}{A string, define the path of MedDRA directory.}

\item{add_smq}{A bool, indicates whether Standardised MedDRA Queries (SMQ)
should be added. If \code{TRUE}, "smq_content.asc", and "smq_list.asc" must exist.}

\item{primary_soc}{A bool, indicates whether keep primary soc only.}

\item{object}{A \code{MedDRA} object.}

\item{...}{Other arguments passed to specific methods.}
}
\value{
\itemize{
\item \code{meddra}: A \code{MedDRA} object.
\item \code{meddra_hierarchy}: Extract the \code{hierarchy} slot.
\item \code{meddra_smq}: Extract the \code{smq} slot.
\item \code{meddra_version}: Extract the \code{version} slot.
}
}
\description{
Provide a container for MedDRA Data file
}
\section{Slots}{

\describe{
\item{\code{hierarchy}}{A \link[data.table:data.table]{data.table} or \code{NULL} representing
the meddra hierarchy data. There are five levels to the MedDRA hierarchy,
arranged from very specific to very general.}

\item{\code{smq}}{A \link[data.table:data.table]{data.table} or \code{NULL} representing the
meddra smq data. Standardised MedDRA Queries (SMQs) are used to support
signal detection and monitoring. SMQs are validated, standard sets of MedDRA
terms. These sets of terms have undergone extensive review, testing, analysis
and expert discussion. SMQs represent a variety of safety topics of
regulatory interest (e.g., SMQ Severe cutaneous adverse reactions, SMQ
Anaphylactic reaction).}

\item{\code{version}}{A string, the version of MedDRA.}
}}

\seealso{
\itemize{
\item \url{https://www.meddra.org/}
\item \url{https://www.meddra.org/how-to-use/basics/hierarchy}
\item \url{https://www.meddra.org/how-to-use/tools/smqs}
}
}
