% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extraChIPs.R
\docType{package}
\name{extraChIPs-package}
\alias{extraChIPs}
\alias{extraChIPs-package}
\title{extraChIPs: A package for enabling and extending ChIP-Seq analysis}
\description{
The package provides three categories of important functions:
Range-based, Visualisation and Convenience functions, with most centred
around GenomicRanges objects
}
\section{Range-based Functions}{


Many of the range-based functions included in this package have a focus on
retaining the \code{mcols} information whilst manipulating the ranges, such as
\code{\link[=reduceMC]{reduceMC()}} which not only reduces the Ranges, but collapses the \code{mcols}
into vectors or \link[IRanges:CompressedList-class]{IRanges::CompressedList} objects.
Key function from this group are:
\itemize{
\item \code{\link[=reduceMC]{reduceMC()}}, \code{\link[=setdiffMC]{setdiffMC()}}, \code{\link[=intersectMC]{intersectMC()}}, \code{\link[=unionMC]{unionMC()}}, \code{\link[=distinctMC]{distinctMC()}}
and \code{\link[=chopMC]{chopMC()}}
\item \code{\link[=bestOverlap]{bestOverlap()}} and \code{\link[=propOverlap]{propOverlap()}} provide simple output easily able to
be added as a column within the \code{mcols} element
\item \code{\link[=as_tibble]{as_tibble()}} coerces a GRanges object to a \link[tibble:tibble]{tibble::tibble}.
\item \code{\link[=colToRanges]{colToRanges()}} enables parsing of a single column to a GRanges object,
setting all other columns as the \code{mcols} element.
\item \code{\link[=stitchRanges]{stitchRanges()}} merges nearby ranges setting barrier ranges which cannot
be crossed when merging
\item \code{\link[=partitionRanges]{partitionRanges()}} break apart one set of ranges by another
\item \code{\link[=dualFilter]{dualFilter()}} filters ranges from sliding windows using a guide set of
reference ranges where signal is confidently expected
\item \code{\link[=mergeByCol]{mergeByCol()}} merges overlapping ranges, as produced by sliding windows
\item \code{\link[=mapByFeature]{mapByFeature()}} is able to map a set of GRanges to the most appropriate
gene, using any optional combination of promoters, enhancers and HiC
interactions
\item \code{\link[=grlToSE]{grlToSE()}} takes selected columns from a GRangesList and sets them as
assays within a \link[SummarizedExperiment:RangedSummarizedExperiment-class]{SummarizedExperiment::RangedSummarizedExperiment} object.
Used for combining peak intensities or results across multiple ChIP targets.
}
}

\section{Visualisation Functions}{

\itemize{
\item \code{\link[=plotHFGC]{plotHFGC()}} is a wrapper to Gviz plotting functions, able to take any
combination of HiC, Features, Genes and Coverage (i.e. BigWig) and plot a
specified range.
\item \code{\link[=plotOverlaps]{plotOverlaps()}} visualises overlapping ranges as an UpSet plot or Venn
Diagram
\item \code{\link[=plotProfileHeatmap]{plotProfileHeatmap()}} plots the average signal around a set of ranges,
as prepared by \code{\link[=getProfileData]{getProfileData()}}
\item \code{\link[=plotPie]{plotPie()}} and \code{\link[=plotSplitDonut]{plotSplitDonut()}} enable simple comparison across
multiple annotation columns within a GRanges object.
\item \code{\link[=plotAssayDensities]{plotAssayDensities()}}, \code{\link[=plotAssayPCA]{plotAssayPCA()}} and \code{\link[=plotAssayRle]{plotAssayRle()}} provide
simple interfaces to plotting key values from a
\link[SummarizedExperiment:RangedSummarizedExperiment-class]{SummarizedExperiment::RangedSummarizedExperiment}.
}
}

\section{Convenience Functions}{

\itemize{
\item \code{\link[=fitAssayDiff]{fitAssayDiff()}} enables differential signal analysis on a
SummarizedExperiment object
\item \code{\link[=collapseGenes]{collapseGenes()}} prints a vector of genes for an rmarkdown document,
using italics.
\item \code{\link[=importPeaks]{importPeaks()}} imports large numbers of broadPeak or narrowPeak files
\item \code{\link[=makeConsensus]{makeConsensus()}} forms consensus peaks from overlapping ranges within a
GRangesList()
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/smped/extraChIPs}
  \item Report bugs at \url{https://github.com/smped/extraChIPs/issues}
}

}
\author{
Stevie Pederson
}
\keyword{internal}
