library(evaluomeR)
library(RSKC)
library(sparcl)

dataFrame <- stability(data=ontMetrics, cbi="kmeans", k=3, bs=100)
assay(dataFrame)
# Metric     Mean_stability_k_3
# [1,] "ANOnto"   "0.711599421597794"
# [2,] "AROnto"   "0.834242802235359"
# [3,] "CBOOnto"  "0.836200447888132"
# [4,] "CBOOnto2" "0.836200447888132"
# [5,] "CROnto"   "0.80871022609772"
# [6,] "DITOnto"  "0.802620378293628"
# [7,] "INROnto"  "0.813132039213596"
# [8,] "LCOMOnto" "0.995402775270891"
# [9,] "NACOnto"  "0.705135779579475"
# [10,] "NOCOnto"  "0.902528819875511"
# [11,] "NOMOnto"  "0.793513639960901"
# [12,] "POnto"    "0.660145923222329"
# [13,] "PROnto"   "0.960518110441289"
# [14,] "RFCOnto"  "0.765127486244089"
# [15,] "RROnto"   "0.960518110441289"
# [16,] "TMOnto"   "0.862955680341511"
# [17,] "TMOnto2"  "0.953719590152899"
# [18,] "WMCOnto"  "0.85715656831332"
# [19,] "WMCOnto2" "0.904134166028688"

dataFrame <- stability(data=ontMetrics, cbi="kmeans", k=5, bs=100)
assay(dataFrame)
# Metric     Mean_stability_k_5
# [1,] "ANOnto"   "0.53661574785721"
# [2,] "AROnto"   "0.808877375863211"
# [3,] "CBOOnto"  "0.773161766854306"
# [4,] "CBOOnto2" "0.773161766854306"
# [5,] "CROnto"   "0.747939612559589"
# [6,] "DITOnto"  "0.738901091226716"
# [7,] "INROnto"  "0.804579603939195"
# [8,] "LCOMOnto" "0.703629344931179"
# [9,] "NACOnto"  "0.663958844840551"
# [10,] "NOCOnto"  "0.899994756895055"
# [11,] "NOMOnto"  "0.758789978458299"
# [12,] "POnto"    "0.646480707690646"
# [13,] "PROnto"   "0.782307410022412"
# [14,] "RFCOnto"  "0.726761185593769"
# [15,] "RROnto"   "0.782307410022412"
# [16,] "TMOnto"   "0.88221333660635"
# [17,] "TMOnto2"  "0.830282245373099"
# [18,] "WMCOnto"  "0.747236615208537"
# [19,] "WMCOnto2" "0.752468990321845"

dataFrame <- stabilityRange(data=ontMetrics, cbi="kmeans", k.range = c(3,5), bs=100)
assay(dataFrame)
# Metric     Mean_stability_k_3  Mean_stability_k_4  Mean_stability_k_5
# [1,] "ANOnto"   "0.711599421597794" "0.661877018484356" "0.53661574785721"
# [2,] "AROnto"   "0.834242802235359" "0.905679508527523" "0.808877375863211"
# [3,] "CBOOnto"  "0.836200447888132" "0.809715382620901" "0.773161766854306"
# [4,] "CBOOnto2" "0.836200447888132" "0.809715382620901" "0.773161766854306"
# [5,] "CROnto"   "0.80871022609772"  "0.848428661689236" "0.747939612559589"
# [6,] "DITOnto"  "0.802620378293628" "0.801976319968573" "0.738901091226716"
# [7,] "INROnto"  "0.813132039213596" "0.833324929464065" "0.804579603939195"
# [8,] "LCOMOnto" "0.995402775270891" "0.758953924881616" "0.703629344931179"
# [9,] "NACOnto"  "0.705135779579475" "0.679182045909186" "0.663958844840551"
# [10,] "NOCOnto"  "0.902528819875511" "0.844518653163586" "0.899994756895055"
# [11,] "NOMOnto"  "0.793513639960901" "0.779713596698101" "0.758789978458299"
# [12,] "POnto"    "0.660145923222329" "0.795675361207579" "0.646480707690646"
# [13,] "PROnto"   "0.960518110441289" "0.790969731730725" "0.782307410022412"
# [14,] "RFCOnto"  "0.765127486244089" "0.790802265552443" "0.726761185593769"
# [15,] "RROnto"   "0.960518110441289" "0.790969731730725" "0.782307410022412"
# [16,] "TMOnto"   "0.862955680341511" "0.904973710968594" "0.88221333660635"
# [17,] "TMOnto2"  "0.953719590152899" "0.868195348078741" "0.830282245373099"
# [18,] "WMCOnto"  "0.85715656831332"  "0.854182751568963" "0.747236615208537"
# [19,] "WMCOnto2" "0.904134166028688" "0.883417390847072" "0.752468990321845"


#dataFrame <- stability(data=ontMetrics, cbi="kmeans", k=3, all_metrics = TRUE, bs=100)
#assay(dataFrame)
# Metric        Mean_stability_k_3
# [1,] "all_metrics" "0.846238406081907"

#dataFrame <- stability(data=ontMetrics, cbi="kmeans", k=5, all_metrics = TRUE, bs=100)
#assay(dataFrame)
# Metric        Mean_stability_k_3
# [1,] "all_metrics" "0.803322946463351"

#dataFrame <- stabilityRange(data=ontMetrics, cbi="kmeans", k.range = c(3,5), all_metrics = TRUE, bs=100)
#assay(dataFrame)
# Metric        Mean_stability_k_3  Mean_stability_k_4  Mean_stability_k_5
# [1,] "all_metrics" "0.846238406081907" "0.783588073668732" "0.803322946463351"
