% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilityIndex.R
\name{stabilityRange}
\alias{stabilityRange}
\title{Stability index for a range of k clusters.}
\usage{
stabilityRange(data, k.range = c(2, 15), bs = 100, cbi = "kmeans",
  getImages = FALSE, all_metrics = FALSE, seed = NULL, ...)
}
\arguments{
\item{data}{A \code{\link{SummarizedExperiment}}.
The SummarizedExperiment must contain an assay with the following structure:
A valid header with names. The first  column of the header is the ID or name
of the instance of the dataset (e.g., ontology, pathway, etc.) on which the
metrics are measured.
The other columns of the header contains the names of the metrics.
The rows contains the measurements of the metrics for each instance in the dataset.}

\item{k.range}{Concatenation of two positive integers.
The first value \code{k.range[1]} is considered as the lower bound of the range,
whilst the second one, \code{k.range[2]}, as the higher. Both values must be
contained in [2,15] range.}

\item{bs}{Positive integer. Bootstrap value to perform the resampling.}

\item{cbi}{Clusterboot interface name (default: "kmeans"):
"kmeans", "clara", "clara_pam", "hclust", "pamk", "pamk_pam", "pamk".
Any CBI appended with '_pam' makes use of \code{\link{pam}}.
The method used in 'hclust' CBI is "ward.D2".}

\item{getImages}{Boolean. If true, a plot is displayed.}

\item{all_metrics}{Boolean. If true, clustering is performed upon all the dataset.}

\item{seed}{Positive integer. A seed for internal bootstrap.}
}
\value{
A \code{\link{ExperimentList}} containing the stability and cluster measurements
 for 2 to \code{k} clusters.
}
\description{
This analysis permits to estimate whether the clustering is meaningfully
affected by small variations in the sample. For a range of k values (\code{k.range}),
a clustering using the k-means algorithm is carried out.
Then, the stability index is the mean of the Jaccard coefficient
values of a number of \code{bs} bootstrap replicates. The values are in the range [0,1],
having the following meaning:
\itemize{
\item Unstable: [0, 0.60[.
\item Doubtful: [0.60, 0.75].
\item Stable: ]0.75, 0.85].
\item Highly Stable: ]0.85, 1].
}
}
\examples{
# Using example data from our package
data("ontMetrics")
result <- stabilityRange(ontMetrics, k.range=c(2,3))

}
\references{
\insertRef{milligan1996measuring}{evaluomeR}

\insertRef{jaccard1901distribution}{evaluomeR}
}
