% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpivizChart-class.R
\docType{class}
\name{EpivizChart-class}
\alias{EpivizChart-class}
\alias{EpivizChart}
\title{Data container for an Epiviz chart component.}
\description{
Data container for an Epiviz chart component.
}
\section{Fields}{

\describe{
\item{\code{data}}{(list) Values of an epiviz chart's data attribute.}

\item{\code{colors}}{(character) Epiviz chart's colors attribute.}

\item{\code{settings}}{(list) Epiviz chart's settings attribute.}

\item{\code{parent}}{An object of class \code{\link{EpivizEnvironment}} where chart is appended.}
}}

\section{Methods}{

\describe{
\item{\code{get_attributes()}}{Get attributes for rendering chart}

\item{\code{get_available_settings()}}{Get available settings}

\item{\code{get_colors()}}{Get chart colors}

\item{\code{get_data()}}{Get chart data}

\item{\code{get_parent()}}{Get parent}

\item{\code{get_settings()}}{Get chart settings}

\item{\code{navigate(chr, start, end)}}{Navigate chart to a genomic location
\describe{
  \item{chr}{Chromosome}
  \item{start}{Start location}
  \item{end}{End location}
}}

\item{\code{render_component(shiny = FALSE)}}{Render to html}

\item{\code{revisualize(chart_type)}}{Revisualize chart as the given chart type
\describe{
  \item{chart_type}{The type of chart to be visualized
  (BlocksTrack, HeatmapPlot, LinePlot, LineTrack, ScatterPlot,
  StackedLinePlot, StackedLineTrack)}
}}

\item{\code{set_colors(colors)}}{Set chart colors}

\item{\code{set_data(data)}}{Set chart data}

\item{\code{set_settings(settings)}}{Modify current settings
\describe{
  \item{settings}{List of new settings.
    Call get_available_settings for settings available to modify.
  }
}}
}}

