% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pv.R
\name{p.asympt}
\alias{p.asympt}
\title{Asymptotic P-values}
\usage{
p.asympt(ss, df, lambda, eps = 1e-14, eps.updt = 2, eps.stop = 1e-10)
}
\arguments{
\item{ss}{numerator of the pseudo-F statistic.}

\item{df}{degrees of freedom of the
numerator of the pseudo-F statistic.}

\item{lambda}{eigenvalues of the residual covariance matrix.}

\item{eps}{the desired level of accuracy.}

\item{eps.updt}{factor by which \code{eps}
is updated to retry execution of
algorithm AS 204 when it fails with
fault indicator 4, 5 or 9.}

\item{eps.stop}{if \code{eps > eps.stop},
execution of algorithm AS 204 is
not retried and the function
raises an error. Default is \code{1e-10}.}
}
\value{
A vector containing the P-value
and the level of accuracy.
}
\description{
Computes asymptotic P-values given the numerator
of the pseudo-F statistic,
its degrees of freedom and the eigenvalues of the
residual covariance matrix.
}
\seealso{
\code{\link{AS204}}
}
\author{
Diego Garrido-Martín
}
\keyword{internal}
