% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_cpg.R
\name{annotate_cpg}
\alias{annotate_cpg}
\title{Annotate the DMR resulting from epimutacions package}
\usage{
annotate_cpg(
  data,
  db,
  split = ",",
  epi_col = "cpg_ids",
  gene_col = "GencodeBasicV12_NAME",
  feat_col = "Regulatory_Feature_Group",
  relat_col = "Relation_to_Island",
  build = "37",
  omim = TRUE
)
}
\arguments{
\item{data}{DataFrame-like object.}

\item{db}{a character string specifying the
Database to use for annotation.
E.g: \code{'IlluminaHumanMethylationEPICanno.ilm10b2.hg19'}.}

\item{split}{a character string containing the separator for CpG ids.
Default \code{','}.}

\item{epi_col}{CpG ids, should be row names in the data base.}

\item{gene_col}{column name from where to extract gene names.
Default: \code{'GencodeBasicV12_NAME'}.}

\item{feat_col}{column name from where to extract CpG feature groups.
Default: \code{'Regulatory_Feature_Group'}.}

\item{relat_col}{column name from where
to extract relation to island info.
Default: \code{'Relation_to_Island'}.}

\item{build}{The build for bioMart. Default \code{'37'}.}

\item{omim}{a boolean, if TRUE will annotate OMIMs as well.
Takes a bit longer. Default TRUE.}
}
\value{
The function returns a
DataFrame-like object annotated.
}
\description{
This function annotates a differentially
methylated region
}
