% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateTransitionProb.R
\name{estimateTransitionProb}
\alias{estimateTransitionProb}
\title{Estimate transition probability from a sequence of integers}
\usage{
estimateTransitionProb(chain, numStates)
}
\arguments{
\item{chain}{a vector of integers}

\item{numStates}{an integer, the number of states in the Markov chain}
}
\value{
A k-by-k matrix of transition probabilities, such that k is the 
number of states of the chain
}
\description{
This function estimates the transition probabilities for a k-state Markov
chain based on a sequence of integers that represent states of the chain
}
\examples{

trueMat <- matrix(c(0.9,0.1,0.1,0.9),2,2)
simChain <- simulateMarkovChain(trueMat,1e3)
estMat <- estimateTransitionProb(simChain,2)

# estMat should be close to trueMat
estMat

}
\references{
\url{https://github.com/plbaldoni/epigraHMM}
}
