% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichViewNet.R
\docType{data}
\name{rosaNapaVsDMSODEG}
\alias{rosaNapaVsDMSODEG}
\title{The result of a differential expression analysis done between 
napabucasin treated and DMSO control MiaPaCa2 cells stably expressing 
the Rosa26 control vector. The cells were treated for 2 hours  
with 0.5 uM napabucasin.
The protocol to generate the RNA-seq is described 
in Froeling F.E.M. et al 2019.}
\format{
a \code{data.frame} containing the results of a differential 
expression analysis between napabucasin treated and DMSO control MiaPaCa2 
cells stably expressing the Rosa26 control vector for all 23542 genes 
tested. The 4 columns are:
\itemize{
\item{\code{"EnsemblID"}: a \code{character} string representing the 
unique Ensembl identifier for the tested gene}
\item{\code{"log2FoldChange"}: a \code{numeric} representing the expression 
difference (in log2FoldChange) between the napabucasin treatment and 
the DMSO control for the tested gene}
\item{\code{"padj"}: a \code{numeric} representing the adjusted p-value 
associated to the difference in expression for the tested gene}
\item{\code{"GeneName"}: a \code{character} string representing the name of 
the tested gene}
}
}
\source{
The original RNA-sequencing data is available at the Gene Expression 
Omnibus (GEO) under the accession number GSE135352.
}
\usage{
data(rosaNapaVsDMSODEG)
}
\value{
a \code{data.frame} containing the results of a differential 
expression analysis between napabucasin treated and DMSO control MiaPaCa2 
cells stably expressing the Rosa26 control vector for all 23542 genes 
tested. The 4 columns are:
\itemize{
\item{\code{"EnsemblID"}: a \code{character} string representing the 
unique Ensembl identifier for the tested gene}
\item{\code{"log2FoldChange"}: a \code{numeric} representing the expression 
difference (in log2FoldChange) between the napabucasin treatment and 
the DMSO control for the tested gene}
\item{\code{"padj"}: a \code{numeric} representing the adjusted p-value 
associated to the difference in expression for the tested gene}
\item{\code{"GeneName"}: a \code{character} string representing the name of 
the tested gene}
}
}
\description{
The object is a \code{data.frame} with 23542 rows and 4 columns. 
Each row correspond to a tested gene.
}
\details{
The differentially expressed genes between napabucasin-treated 
cells (0.5 uM) and DMSO as vehicle control are reprinted from Clinical 
Cancer Research, 2019, 25 (23), 7162–7174, Fieke E.M. Froeling, Manojit 
Mosur Swamynathan, Astrid Deschênes, Iok In Christine Chio, Erin Brosnan, 
Melissa A. Yao, Priya Alagesan, Matthew Lucito, Juying Li, An-Yun Chang, 
Lloyd C. Trotman, Pascal Belleau, Youngkyu Park, Harry A. Rogoff, 
James D. Watson, David A. Tuveson, Bioactivation of napabucasin triggers 
reactive oxygen species–mediated cancer cell death, with permission 
from AACR.
}
\examples{

## Required library
library(gprofiler2)

## Loading dataset containing the results of a differentially expressed 
## analysis between 2-hour treatment with 0.5 uM napabucasin and 
## DMSO vehicle control MiaPaCa2 cells stably expressing the 
## Rosa26 control vector
data(rosaNapaVsDMSODEG)

allGenes <- unique(rosaNapaVsDMSODEG$EnsemblID)

## Select the significantly differentially expressed genes
selection <- which(abs(rosaNapaVsDMSODEG$log2FoldChange) > 1 & 
                            rosaNapaVsDMSODEG$padj < 0.05)
                            
selectedGenes <- unique(rosaNapaVsDMSODEG$EnsemblID[selection])

## Run an enrichment analysis using Transfac dataset (transcription factor)
gostres <- gost(query = list(rosa_napa_vs_DMSO=selectedGenes),
    organism="hsapiens",
    correction_method = "g_SCS",
    sources=c("TF"), significant=TRUE, evcodes=TRUE,
    custom_bg=allGenes, exclude_iea=TRUE)



}
\seealso{
\itemize{
    \item{\link{createNetwork} for transforming functional 
    enrichment results from gprofiler2 into a Cytoscape network}
    \item{\link{createEnrichMap} for transforming functional 
    enrichment results from gprofiler2 into an enrichment map}
}
}
\keyword{datasets}
