% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchTFBPS.R
\name{searchTFBPS}
\alias{searchTFBPS}
\title{Transcription Factor Binding Pattern Similarity (TFBPS) search}
\usage{
searchTFBPS(
  query,
  subject,
  PWMs,
  queryGenome,
  background = "genome",
  ...,
  maximalShuffleEnhancers = 1000
)
}
\arguments{
\item{query}{An object of DNAStringSet to represent enhancer}

\item{subject}{Output of getENCODEdata. An object of \link{Enhancers}}

\item{PWMs}{The Position Weight Matrix list represented as a numeric matrix.
Object of \link[TFBSTools:XMatrixList]{PWMatrixList} or
\link[TFBSTools:XMatrixList]{PFMatrixList}.}

\item{queryGenome}{An object of \link[BSgenome:BSgenome-class]{BSgenome} for
query data.}

\item{background}{background nucleotide frequencies. Default is "genome".
Refer \link[motifmatchr]{matchMotifs} for details.}

\item{\dots}{Parameters will be passed to \link[motifmatchr]{matchMotifs}
except 'out' and 'genome'.}

\item{maximalShuffleEnhancers}{The maximal number of Shuffled enhancers.
If the number of the input enhancer candidates is greater than
maximalShuffleEnhancers, no shuffled enhancer sequences will be included.
The shuffled enhancers will be created by \link{shuffle}.}
}
\value{
An object of \link{Enhancers}.
}
\description{
Search the TFBPs for query in subject.
}
\examples{
library(BSgenome.Hsapiens.UCSC.hg38)
peaks <- GRanges("chr1", IRanges(seq(5000, 50000, by=1000), width=1000))
peaks$id <- paste(seq_along(peaks), 1, sep="_")
subj <- Enhancers(genome=Hsapiens, peaks=peaks)
q <- getSeq(Hsapiens, GRanges("chr1", IRanges(90000, width=1000)))
data(motifs)
ao <- searchTFBPS(q, subj, motifs[["dist60"]], queryGenome=Hsapiens,
                  maximalShuffleEnhancers = 50)
}
