% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/deSet-methods.R
\docType{methods}
\name{apply_sva}
\alias{apply_sva}
\alias{apply_sva,deSet-method}
\title{Estimate surrogate variables}
\usage{
apply_sva(object, ...)

\S4method{apply_sva}{deSet}(object, ...)
}
\arguments{
\item{object}{\code{S4 object}: \code{\linkS4class{deSet}}}

\item{...}{Additional arguments for \code{\link{sva}}}
}
\value{
\code{\linkS4class{deSet}} object where the surrogate variables 
estimated by \code{\link{sva}} are added to the full model and null model
matrices.
}
\description{
Runs \code{\link{sva}} on the null and full models in
\code{\linkS4class{deSet}}. See \code{\link{sva}} for additional details.
}
\examples{
# import data
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- build_models(data = kidexpr, cov = cov, null.model = null_model,
full.model = full_model)

# run surrogate variable analysis
de_sva <- apply_sva(de_obj)

# run odp/lrt with surrogate variables added
de_odp <- odp(de_sva, bs.its = 30)
summary(de_odp)
}
\author{
John Storey, Jeffrey Leek, Andrew Bass
}
\references{
Leek JT, Storey JD (2007) Capturing Heterogeneity in Gene Expression
Studies by Surrogate Variable Analysis. PLoS Genet 3(9): e161.
doi:10.1371/journal.pgen.0030161

Leek JT and Storey JD. (2008) A general framework for multiple testing
dependence. Proceedings of the National Academy of Sciences, 105: 18718-
18723.
}
\seealso{
\code{\linkS4class{deSet}}, \code{\link{odp}} and
\code{\link{lrt}}
}

