% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyRNASeq-internal-annotation.R
\name{easyRNASeq annotation internal methods}
\alias{easyRNASeq annotation internal methods}
\alias{.getBmRange}
\alias{.getGffRange}
\alias{.getGtfRange}
\alias{.geneModelAnnotation}
\alias{.readGffGtf}
\title{Internal easyRNASeq annotation methods}
\usage{
.getBmRange(obj, ...)
}
\arguments{
\item{obj}{an \code{\linkS4class{AnnotParam}} object containing the
necessary retrieval information (datasource and type)}

\item{...}{Additional arguments, passed to more internal functions.}

\item{annotation.type}{describes the kind of annotation to keep the
information from in a gtf or gff file. If set to NULL all the annotations
are returned.}

\item{fields}{added a parameter that allows defining the fields parsed from
a gtf file. Still internal, but could easily be externalized.}

\item{filename}{filename that contains the annotations}

\item{format}{describes the kind of annotation provided. One of gtf or gff.}

\item{gAnnot}{a \code{\linkS4class{GRanges}} object containing exon
annotations}

\item{nbCore}{number of CPU cores to use}
}
\value{
A \code{\linkS4class{GRanges}} containing the loaded or
processed annotations.
}
\description{
These are internal methods used to retrieve annotations tabularll
\code{.getBmRange}Use \code{\link[biomaRt:useMart]{biomaRt}} to get exon
annotations.  \code{.getGffRange}Use
\code{\linkS4class{Genome_intervals_stranded}} to get annotation from a gff
file.  \code{.getGtfRange}Use
\code{\linkS4class{Genome_intervals_stranded}} to get annotation from a gtf
file.  \code{.geneModelAnnotation}Use the provided exon annotation to
define gene models.  \code{.readGffGtf}Use
\code{\linkS4class{Genome_intervals_stranded}} to get annotation from a gff
or gtf file. It is called from \code{getGffRange} and \code{getGtfRange}.
}
\details{
To use multicore machines more efficiently, the default parallel package
will be used to parallelize the processing.
}
\author{
Nicolas Delhomme
}
\keyword{internal}
