% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_RIR.R
\name{compute_RIR}
\alias{compute_RIR}
\title{Compute three scores from the immune resistance program:
resF_down (RIR), resF_up, resF (resF_up - resF_down)}
\usage{
compute_RIR(RNA_tpm, RIR_program)
}
\arguments{
\item{RNA_tpm}{data.frame containing TPM values with HGNC symbols
in rows and samples in columns.}

\item{RIR_program}{list with gene signatures included in the immune
resistance program from Jerby-Arnon et al., 2018.}
}
\value{
A numeric matrix with samples in rows and three RIR scores as
columns: "resF_up" (upregulated score), "resF_down" (downregulated score)
and "resF" (upregulated score - downregulated score).
}
\description{
Calculates RIR score by combining a set of gene
signatures associated with upregulation and
downregulation of T cell exclusion, post-treatment
and functional resistance.
We used the original approach defined in Jerby-Arnon
et al., Cell, 2018.
}
\details{
The gene signatures were provided by original work:
https://github.com/livnatje/ImmuneResistance
}
\references{
Jerby-Arnon, L., Shah, P., Cuoco, M.S.,
Rodman, C., Su, M.-J., Melms, J.C., Leeson, R., Kanodia,
A., Mei, S., Lin, J.-R., et al. (2018). A Cancer Cell
Program Promotes T Cell Exclusion and Resistance to
Checkpoint Blockade. Cell 175, 984–997.e24.
https://doi.org/10.1016/j.cell.2018.09.006.
}
