\name{drugTargetAnnot}
\alias{drugTargetAnnot}
\alias{queryBy}
\title{
drugTargetAnnot
}
\description{
 Function to query known drug-target annotations.
}
\usage{
drugTargetAnnot(queryBy=list(molType=NULL, idType=NULL, ids=NULL), cmpid_file=file.path(config$resultsPath,"cmp_ids.rds"), config=genConfig())
}
\arguments{
  \item{queryBy}{
	  A list defining the query, as described in  \code{\link{queryBy}}.
}
  \item{cmpid_file}{
	  Path to a compound ID mapping file, generated by \code{\link{cmpIdMapping}}.
	
}
	\item{config}{ General configuration. See \code{\link{genConfig}}.  }
}
\value{
	Returns the query results as a data frame.
}
\author{
	Thomas Girke
}


\seealso{
	\code{\link{queryBy}}
	\code{\link{cmpIdMapping}}
}
\examples{	
	# Tthese are just sample files included in the package. 
	# You should use your own data files.
	config = genConfig(chemblDbPath= 
									system.file("extdata", "chembl_sample.db", package="drugTargetInteractions"),
							  resultsPath = 
									system.file("extdata", "results", package="drugTargetInteractions"))

	queryBy <- list(molType="cmp", idType="chembl_id", ids=c("CHEMBL1233058", "CHEMBL1200916", "CHEMBL437765"))
	qresult <- drugTargetAnnot(queryBy, config=config)
}
