% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeConstantTerms.R
\name{removeConstantTerms}
\alias{removeConstantTerms}
\title{Remove constant terms from formula}
\usage{
removeConstantTerms(formula, data)
}
\arguments{
\item{formula}{original formula}

\item{data}{data.frame}
}
\value{
a formula, possibly with terms omitted.
}
\description{
Remove constant terms from formula.  Also remove categorical variables with a max of one example per category
}
\details{
Adapted from \code{MoEClust::drop_constants}
}
\examples{

# Valid formula
removeConstantTerms(~ group + extra, sleep)

# there is no variation in 'group' in this dataset
removeConstantTerms(~ group + extra, sleep[1:3, ])

}
