% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processAssays.R
\name{processAssays}
\alias{processAssays}
\title{Processing SingleCellExperiment to dreamletProcessedData}
\usage{
processAssays(
  sceObj,
  formula,
  assays = assayNames(sceObj),
  min.cells = 5,
  min.count = 5,
  min.samples = 4,
  min.prop = 0.4,
  isCounts = TRUE,
  normalize.method = "TMM",
  span = "auto",
  quiet = FALSE,
  weightsList = NULL,
  BPPARAM = SerialParam(),
  ...
)
}
\arguments{
\item{sceObj}{SingleCellExperiment object}

\item{formula}{regression formula for differential expression analysis}

\item{assays}{array of assay names to include in analysis. Defaults to \code{assayNames(sceObj)}}

\item{min.cells}{minimum number of observed cells for a sample to be included in the analysis}

\item{min.count}{used to compute a CPM threshold of \code{CPM.cutoff = min.count/median(lib.size)*1e6}.  Passed to \code{edgeR::filterByExpr()}}

\item{min.samples}{minimum number of samples passing cutoffs for cell cluster to be retained}

\item{min.prop}{minimum proportion of retained samples with \code{CPM > CPM.cutoff}}

\item{isCounts}{logical, indicating if data is raw counts}

\item{normalize.method}{normalization method to be used by \code{calcNormFactors}}

\item{span}{Lowess smoothing parameter using by \code{variancePartition::voomWithDreamWeights()}}

\item{quiet}{show messages}

\item{weightsList}{list storing matrix of precision weights for each cell type. If \code{NULL} precision weights are set to 1}

\item{BPPARAM}{parameters for parallel evaluation}

\item{...}{other arguments passed to \code{dream}}
}
\value{
Object of class \code{dreamletProcessedData} storing voom-style normalized expression data
}
\description{
For raw counts, estimate precision weights using linear mixed model weighting by number of cells observed for each sample.  For normalized data, only weight by number of cells.
}
\details{
For each cell cluster, samples with at least \code{min.cells} are retained. Only clusters with at least \code{min.samples} retained samples are kept. Genes are retained if they have at least \code{min.count} reads in at least \code{min.prop} fraction of the samples.  Current values are reasonable defaults, since genes that don't pass these cutoffs are very underpowered for differential expression analysis and only increase the multiple testing burden.  But values of \code{min.cells = 2} and \code{min.count = 2} are also reasonable to include more genes in the analysis.

The precision weights are estimated using the residuals fit from the specified formula.  These weights are robust to changes in the formula as long as the major variables explaining the highest fraction of the variance are included.

If \code{weightsList} is \code{NULL}, precision weights are set to 1 internally.
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)
#
}
\seealso{
\code{voomWithDreamWeights()}
}
