% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVolcano.R
\docType{methods}
\name{plotVolcano}
\alias{plotVolcano}
\alias{plotVolcano,list-method}
\alias{plotVolcano,list,list-method}
\alias{plotVolcano,MArrayLM-method}
\alias{plotVolcano,MArrayLM,MArrayLM-method}
\alias{plotVolcano,dreamlet_mash_result-method}
\alias{plotVolcano,dreamlet_mash_result,dreamlet_mash_result-method}
\title{Volcano plot for each cell type}
\usage{
plotVolcano(
  x,
  coef,
  nGenes = 5,
  size = 12,
  minp = 9.99999999999997e-311,
  cutoff = 0.05,
  ncol = 3,
  ...
)

\S4method{plotVolcano}{list}(
  x,
  coef,
  nGenes = 5,
  size = 12,
  minp = 9.99999999999997e-311,
  cutoff = 0.05,
  ncol = 3,
  assays = names(x),
  ...
)

\S4method{plotVolcano}{MArrayLM}(
  x,
  coef,
  nGenes = 5,
  size = 12,
  minp = 9.99999999999997e-311,
  cutoff = 0.05,
  ncol = 3,
  ...
)

\S4method{plotVolcano}{dreamlet_mash_result}(
  x,
  coef,
  nGenes = 5,
  size = 12,
  minp = 1e-16,
  cutoff = 0.05,
  ncol = 3,
  assays = colnames(x$logFC.original),
  ...
)
}
\arguments{
\item{x}{result from \code{dreamlet}}

\item{coef}{coefficient to test with \code{topTable}}

\item{nGenes}{number of genes to highlight in each volcano plot}

\item{size}{text size}

\item{minp}{minimum p-value to show on the y-axis}

\item{cutoff}{adj.P.Val cutoff to distinguish significant from non-significant genes}

\item{ncol}{number of columns in the plot}

\item{...}{arguments passed to \code{facet_wrap()}. Useful for specifying \code{scales = "free_y"}}

\item{assays}{which assays to plot}
}
\value{
Volcano plot for each cell type
}
\description{
Volcano plot for each cell type
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)

# show coefficients estimated for each cell type
coefNames(res.dl)

# volcano plot for each cell type
plotVolcano(res.dl, coef = "group_idstim")

# volcano plot for first two cell types
plotVolcano(res.dl[1:2], coef = "group_idstim")

}
