% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPercentBars.R
\name{plotPercentBars,vpDF-method}
\alias{plotPercentBars,vpDF-method}
\alias{plotPercentBars,vpDF,vpDF-method}
\alias{plotPercentBars,cellSpecificityValues-method}
\alias{plotPercentBars,cellSpecificityValues,cellSpecificityValues-method}
\title{Bar plot of variance fractions}
\usage{
\S4method{plotPercentBars}{vpDF}(
  x,
  col = c(ggColorHue(ncol(x) - 3), "grey85"),
  genes = unique(x$gene),
  width = NULL,
  ncol = 3,
  ...
)

\S4method{plotPercentBars}{cellSpecificityValues}(
  x,
  col = ggColorHue(ncol(x)),
  genes = rownames(x),
  width = NULL,
  ...
)
}
\arguments{
\item{x}{\code{vpDF} object returned by \code{fitVarPart()}}

\item{col}{color of bars for each variable}

\item{genes}{name of genes to plot}

\item{width}{specify width of bars}

\item{ncol}{number of columns in the plot}

\item{...}{other arguments}
}
\value{
Bar plot showing variance fractions for each gene
}
\description{
Bar plot of variance fractions for a subset of genes
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# variance partitioning analysis
vp <- fitVarPart(res.proc, ~group_id)

# Show variance fractions at the gene-level for each cell type
plotPercentBars(vp, genes = vp$gene[2:4], ncol = 2)

}
