% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitVarPart.R
\name{fitVarPart}
\alias{fitVarPart}
\alias{fitVarPart,dreamletProcessedData-method}
\title{Variance Partition analysis for each assay}
\usage{
fitVarPart(
  x,
  formula,
  data = colData(x),
  assays = assayNames(x),
  quiet = FALSE,
  BPPARAM = SerialParam(),
  ...
)

\S4method{fitVarPart}{dreamletProcessedData}(
  x,
  formula,
  data = colData(x),
  assays = assayNames(x),
  quiet = FALSE,
  BPPARAM = SerialParam(),
  ...
)
}
\arguments{
\item{x}{SingleCellExperiment or dreamletProcessedData object}

\item{formula}{regression formula for differential expression analysis}

\item{data}{metadata used in regression formula}

\item{assays}{array of assay names to include in analysis. Defaults to \code{assayNames(x)}}

\item{quiet}{show messages}

\item{BPPARAM}{parameters for parallel evaluation}

\item{...}{other arguments passed to \code{dream}}
}
\value{
Object of class \code{vpDF} inheriting from \code{DataFrame} storing the variance fractions for each gene and cell type.
}
\description{
Perform Variance Partition analysis  for each assay
}
\examples{

library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# variance partitioning analysis
vp <- fitVarPart(res.proc, ~group_id)

# Show variance fractions at the gene-level for each cell type
genes <- vp$gene[2:4]
plotPercentBars(vp[vp$gene \%in\% genes, ])

# Summarize variance fractions genome-wide for each cell type
plotVarPart(vp)

}
