% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateNonCountSignal.R
\name{aggregateNonCountSignal}
\alias{aggregateNonCountSignal}
\title{Aggregation of single-cell signals}
\usage{
aggregateNonCountSignal(
  sce,
  assay = NULL,
  sample_id = NULL,
  cluster_id = NULL,
  min.cells = 10,
  min.signal = 0.01,
  min.samples = 4,
  min.prop = 0.4,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)
}
\arguments{
\item{sce}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{assay}{character string specifying the assay slot to use as
input data. Defaults to the 1st available (\code{assayNames(x)[1]}).}

\item{sample_id}{character string specifying which variable to use as sample id}

\item{cluster_id}{character string specifying which variable to use as cluster id}

\item{min.cells}{minimum number of observed cells for a sample to be included in the analysis}

\item{min.signal}{minimum signal value for a gene to be considered expressed in a sample.  Proper value for this cutoff depends on the type of signal value}

\item{min.samples}{minimum number of samples passing cutoffs for cell cluster to be retained}

\item{min.prop}{minimum proportion of retained samples with non-zero counts for a gene to be}

\item{verbose}{logical. Should information on progress be reported?}

\item{BPPARAM}{a \code{\link[BiocParallel]{BiocParallelParam}}
object specifying how aggregation should be parallelized.}
}
\value{
a \code{dreamletProcessedData} object
}
\description{
Aggregation of single-cell to pseudobulk data for non-count data.
}
\details{
The \code{dreamlet} workflow can also be applied to non-count data. In this case, a signal is averaged across all cells from a given sample and cell type. Here \code{aggregateNonCountSignal()} performs the roles of \code{aggregateToPseudoBulk()} followed by \code{processAssays()} but using non-count data.

For each cell cluster, samples with at least \code{min.cells} are retained. Only clusters with at least \code{min.samples} retained samples are kept. Features are retained if they have at least \code{min.signal} in at least min.prop fraction of the samples.

The precision of a measurement is the inverse of its sampling variance. The precision weights are computed as \code{1/sem^2}, where \code{sem = sd(signal) / sqrt(n)}, \code{signal} stores the values averaged across cells, and \code{n} is the number of cells.
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
# using non-count signal
pb.signal <- aggregateNonCountSignal(example_sce,
  assay = "logcounts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(pb.signal, ~group_id)
}
