% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_from_api.R
\name{extract_feat_acc}
\alias{extract_feat_acc}
\title{Create a dataframe of protein features from JSON object (List of 6)}
\usage{
extract_feat_acc(features_list)
}
\arguments{
\item{features_list}{A JSON object - list of 6 with features inside. Created
as one of the lists in the list of lists by the get_features() function.}
}
\value{
A dataframe with features: "type", "description", "begin", "end" and
adds accession, entryName and taxid for each row.
}
\description{
Converts the list of 6 JSON object created by getting the features from
UniProt. Used in the feature_to_dataframe(). Does not give order. Does not
operate on List of lists - just the list of 6.
}
\examples{
data("five_rel_list")
one_protein_features <- extract_feat_acc(five_rel_list[[1]])
head(one_protein_features)

}
