% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{draw_repeat}
\alias{draw_repeat}
\title{Add protein repeats sites to ggplot2 object.}
\usage{
draw_repeat(p, data = data, label_size = 2, outline = "dimgrey",
            fill = "dimgrey", alpha = 1.0,
            label_repeats = TRUE, show.legend = TRUE)
}
\arguments{
\item{p}{ggplot2 object ideally created with \code{\link{draw_canvas}}.}

\item{data}{Dataframe of one or more rows with the following column
names: 'type', 'description', 'begin', 'end', 'length', 'accession',
'entryName', 'taxid', 'order'. Must contain a minimum of one "CHAIN" as
data$type.}

\item{label_size}{Size of text used for labels of protein repeats.}

\item{outline}{Colour of the outline of each repeat.}

\item{fill}{Colour of the fill of each repeat.}

\item{alpha}{Transparency of the rectangles representing the repeats.}

\item{label_repeats}{Option to label repeats or not.}

\item{show.legend}{Option to include legend in this layer}
}
\value{
A ggplot2 object either in the plot window or as an object with an
additional geom_rect layer.
}
\description{
\code{draw_repeat} adds protein repeats from Uniprot to ggplot2 object
created by \code{\link{draw_canvas}} and \code{\link{draw_chains}}.
It uses the data object.
The ggplot2 function \code{geom_rect}
is used to draw each of the motifs proportional to their number of
amino acids (length).
}
\examples{
# combines with draw_chains to plot chains and repeats.
data("five_rel_data")
p <- draw_canvas(five_rel_data)
p <- draw_chains(p, five_rel_data, label_size = 1.25)
draw_repeat(p, five_rel_data)


}
