% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_ks_peaks}
\alias{plot_ks_peaks}
\title{Plot histogram of Ks distribution with peaks}
\usage{
plot_ks_peaks(peaks = NULL, binwidth = 0.05)
}
\arguments{
\item{peaks}{A list with elements \strong{mean}, \strong{sd},
\strong{lambda}, and \strong{ks}, as returned by the
function \code{fins_ks_peaks()}.}

\item{binwidth}{Numeric scalar with binwidth for the histogram.
Default: 0.05.}
}
\value{
A ggplot object with a histogram and lines for each Ks peak.
}
\description{
Plot histogram of Ks distribution with peaks
}
\examples{
data(fungi_kaks)
scerevisiae_kaks <- fungi_kaks$saccharomyces_cerevisiae
ks <- scerevisiae_kaks$Ks

# Find 2 peaks in Ks distribution
peaks <- find_ks_peaks(ks, npeaks = 2)

# Plot
plot_ks_peaks(peaks, binwidth = 0.05)
}
