% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{duplicates2counts}
\alias{duplicates2counts}
\title{Get a duplicate count matrix for each genome}
\usage{
duplicates2counts(duplicate_list, shape = "long")
}
\arguments{
\item{duplicate_list}{A list of data frames with the duplicated genes or
gene pairs and their modes of duplication as returned
by \code{classify_gene_pairs()} or \code{classify_genes()}.}

\item{shape}{Character specifying the shape of the output data frame.
One of "long" (data frame in the long shape, in the tidyverse sense),
or "wide" (data frame in the wide shape, in the tidyverse sense).
Default: "long".}
}
\value{
If \strong{shape = "wide"}, a count matrix containing the
frequency of duplicated genes (or gene pairs) by mode for each species,
with species in rows and duplication modes in columns.
If \strong{shape = "long"}, a data frame in long format with the following
variables:
\describe{
\item{type}{Factor, type of duplication.}
\item{n}{Numeric, number of duplicates.}
\item{species}{Character, species name}
}
}
\description{
Get a duplicate count matrix for each genome
}
\examples{
data(fungi_kaks)

# Get unique duplicates
duplicate_list <- classify_genes(fungi_kaks)

# Get count table
counts <- duplicates2counts(duplicate_list)
}
