% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRatioBoxes.R
\name{plotRatioBoxes}
\alias{plotRatioBoxes}
\title{plotRatioBoxes Function to boxplot density of ratios
between two treatments (using groupings from an annotation column)
within a SummarizedExperiment object.}
\usage{
plotRatioBoxes(se, groupings= NULL, treatment1=NULL, treatment2=NULL,
mode_mean=TRUE, LOG2=TRUE, ...)
}
\arguments{
\item{se}{A SummarizedExperiment object.}

\item{groupings}{A grouping (annotation column), e.g. groupings="something".}

\item{treatment1}{Symbol, treatment 1.}

\item{treatment2}{Symbol, treatment 2.}

\item{mode_mean}{Boolean, Calculate RowMeans or RowMedians.}

\item{LOG2}{Boolean, Calculate LOG2.}

\item{...}{Passthrough arguments to boxplot (additional arguments
affecting the summary produced).}
}
\value{
Returns an invisible data frame containing the values.
}
\description{
This function plots the expression of the supplied
object, representing ratios between a pair of selected
treatments as a boxplot for each group in the selected annotation column.
}
\details{
This function boxplots expression of the supplied
object using ratios of treatment1/treatment2.
}
\examples{
data(hmel.se)
plotRatioBoxes(se, groupings='annotation.ZA', treatment1 = 'Male',
treatment2 = 'Female')
}
\references{
The "doseR" package, 2018 (in press).
}
\author{
AJ Vaestermark, JR Walters.
}
