% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{computeUnivariateSupport}
\alias{computeUnivariateSupport}
\title{Estimate the baseline support}
\usage{
computeUnivariateSupport(seMat, gamma = 0.1, beta = 0.95,
  parallel = TRUE, verbose = TRUE)
}
\arguments{
\item{seMat}{SummariziedExperiment with an assay in [0, 1], with each column corresponding to a sample and each 
row corresponding to a feature; usually in quantile form.}

\item{gamma}{Parameter for selecting radius around each support point (0 < gamma < 1).
By default gamma = 0.1.}

\item{beta}{Parameter for eliminating outliers (0 < beta <= 1). By default beta=0.95.}

\item{parallel}{Logical indicating whether to compute features parallelly with mclapply on
Unix based systems (defaults to TRUE, switched to FALSE if parallel package is not available).}

\item{verbose}{Logical indicating whether to print status related messages during computation (defaults
to TRUE).}
}
\value{
A list with elements "Ranges": data frame with the baseline interval 
for each feature, "Support": binary matrix of the same dimensions as Mat indicating whether each sample was a support 
for a feature or not (1=support, 0=not in the support), "gamma": gamma value, and "alpha": the expected number of divergent 
features per sample estimated over the samples.
}
\description{
Function for computing the basline support for univariate features given gamma
and beta parameters.
}
\examples{
baseMat = breastTCGA_Mat[, breastTCGA_Group == "NORMAL"]
seMat.base = SummarizedExperiment(assays=list(data=baseMat))
assays(seMat.base)$quantile = computeQuantileMatrix(seMat.base)
baseline = computeUnivariateSupport(seMat=seMat.base)

}
\keyword{baseline,}
\keyword{support}
