% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{computeChiSquaredTest}
\alias{computeChiSquaredTest}
\title{Compute chi-squared test}
\usage{
computeChiSquaredTest(Mat, Groups, classes)
}
\arguments{
\item{Mat}{Matrix of digitized binary or ternary data with each column corresponding to a sample and each 
row corresponding to a feature}

\item{Groups}{Factor indicating class association of samples}

\item{classes}{Vector of class labels; the test will be applied between the classes given.}
}
\value{
A data frame with columns 'statistic' and 'pval'.
}
\description{
Given a binary or ternary data matrix with class associations of samples, computes chi-squared tests
for each feature between given groups
}
\examples{
baseMat = breastTCGA_Mat[, breastTCGA_Group == "NORMAL"]
dataMat = breastTCGA_Mat[, breastTCGA_Group != "NORMAL"]
seMat.base = SummarizedExperiment(assays=list(data=baseMat))
seMat = SummarizedExperiment(assays=list(data=dataMat))
div = computeUnivariateDigitization(
  seMat = seMat,
  seMat.base = seMat.base,
 parallel = TRUE
)
assays(seMat)$div = div$Mat.div
sel = which(colnames(seMat) \%in\% colnames(dataMat))
div.chi = computeChiSquaredTest(Mat=assays(seMat)$div, 
                                Groups=breastTCGA_ER[sel],
                                classes=c("Positive", "Negative"))


}
\keyword{chi-squared}
