% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_plotters.R
\name{multi_dittoPlot}
\alias{multi_dittoPlot}
\title{Generates dittoPlots for multiple features.}
\usage{
multi_dittoPlot(
  object,
  vars,
  group.by,
  ncol = 3,
  nrow = NULL,
  main = "var",
  ylab = NULL,
  list.out = FALSE,
  OUT.List = NULL,
  ...,
  xlab = NULL,
  data.out = FALSE,
  do.hover = FALSE,
  legend.show = FALSE
)
}
\arguments{
\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}

\item{vars}{c("var1","var2","var3",...). A vector of gene or metadata names from which to generate the separate plots}

\item{group.by}{String representing the name of a metadata to use for separating the cells/samples into discrete groups.}

\item{ncol, nrow}{Integer or NULL. How many columns or rows the plots should be arranged into.}

\item{main, ylab}{String which sets whether / how plot titles or y-axis labels should be added to each individual plot
\itemize{
\item When set to \code{"var"}, the \code{vars} names alone will be used.
\item When set to \code{"make"}, the default dittoPlot behavior will be observed: For y-axis labels, gene vars will become "'var' expression". Equivalent to "var" for \code{main}.
\item When set as any other string, that string will be used as the title / y-axis label for every plot.
\item When set to \code{NULL}, titles / axes labels will not be added.
}}

\item{list.out}{Logical. (Default = FALSE) When set to \code{TRUE}, a list of the individual plots, named by the \code{vars} being shown in each, is output instead of the combined multi-plot.}

\item{OUT.List}{Deprecated. Use \code{list.out}}

\item{..., xlab, data.out, do.hover, legend.show}{other paramters passed along to \code{\link{dittoPlot}}.}
}
\value{
A set of dittoPlots either arranged into a grid (default), or output as a list.
}
\description{
Generates dittoPlots for multiple features.
}
\details{
Given multiple 'var' parameters to \code{vars}, this function creates a \code{\link{dittoPlot}} for each one, with minor defaulting tweaks (see below).

By default, these dittoPlots are arranged into a grid.
Alternatively, if \code{list.out} is set to \code{TRUE}, they are output as a list with each plot named as the \code{vars} being shown.

All parameters that can be adjusted in dittoPlot can be adjusted here, but the only input that will change between plots is the \code{var}.
}
\section{Slight tweaks to dittoPlot defaults}{

\itemize{
\item axes labels are not shown by default to save space (control with \code{xlab} and \code{ylab})
\item legends are also not shown to save space (control with \code{legend.show})
}
}

\examples{
example(importDittoBulk, echo = FALSE)
genes <- getGenes(myRNA)[1:4]

multi_dittoPlot(myRNA,
    vars = c("gene1", "gene2", "gene3", "gene4"),
    group.by = "clustering")

#To make it output a grid that is 2x2, to add y-axis labels
# instead of titles, and to show legends...
multi_dittoPlot(myRNA, c("gene1", "gene2", "gene3", "gene4"), "clustering",
    nrow = 2, ncol = 2,           #Make grid 2x2 (only one of these needed)
    main = NULL, ylab = "make",   #Add y axis labels instead of titles
    legend.show = TRUE)           #Show legends

# Output as list instead
multi_dittoPlot(myRNA, c("gene1", "gene2", "gene3", "gene4"), "clustering",
    list.out = TRUE)

}
\seealso{
\code{\link{dittoPlot}} for the single plot version of this function and details on all accepted inputs. 

\code{\link{dittoDotPlot}} and \code{\link{dittoPlotVarsAcrossGroups}} to show, in a single plot, per-group summaries of the values for multiple vars.
}
\author{
Daniel Bunis
}
