% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{deuBinPlot}
\alias{deuBinPlot}
\title{deuBinPlot}
\usage{
deuBinPlot(
  se,
  gene,
  type = c("summary", "condition", "sample"),
  intronSize = 2,
  exonSize = c("sqrt", "linear", "log"),
  y = NULL,
  condition = NULL,
  size = "type",
  lineSize = 1,
  colour = NULL,
  alpha = NULL,
  removeAmbiguous = TRUE,
  minDensityRatio = 0.1
)
}
\arguments{
\item{se}{A bin-wise SummarizedExperiment as produced by
\code{\link{countFeatures}} and including bin-level tests (i.e. having been
passed through one of the DEU wrappers such as
\code{\link{diffSpliceWrapper}} or \code{\link{DEXSeqWrapper}})}

\item{gene}{The gene of interest}

\item{type}{Either 'summary' (plot DEU summary), 'sample' (plot sample-wise
data), or 'condition' (plot data aggregate by condition)}

\item{intronSize}{Intron plot size. If <=3, intron size will be this
fraction of the mean exon size. If >3, each intron will have the given size.}

\item{exonSize}{Scaling for exon sizes, either 'sqrt', 'log', or 'linear'.}

\item{y}{Value to plot on the y-axis. If `type="summary"`, this should be a
column of `rowData(se)`, otherwise should be an assay name of `se`.}

\item{condition}{The colData column containing the samples' condition.}

\item{size}{rowData variable to use to determine the thickness of the bins.}

\item{lineSize}{Size of the line connecting the bins. Use `lineSize=0` to
omit the line.}

\item{colour}{rowData variable to use to determine the colour of the bins.
If `type="condition"`, can also be "condition"; if `type="sample"` can be
any colData column.}

\item{alpha}{Alpha level, passed to ggplot.}

\item{removeAmbiguous}{Logical; whether to remove bins that are
gene-ambiguous (i.e. overlap multiple genes).}

\item{minDensityRatio}{Minimum ratio of read density (with respect to the 
gene's average) for a bin to be plotted.}
}
\value{
A ggplot object
}
\description{
deuBinPlot
}
\examples{
data(example_bin_se)
se <- diffSpliceWrapper(example_bin_se, ~condition)
deuBinPlot(se, "Jund")
}
