## Setup1
suppressPackageStartupMessages(library("IRanges"))
suppressWarnings(RNGversion("3.5.0"))
set.seed(20140916)
toyData <- DataFrame(
    "sample1" = Rle(sample(0:10, 1000, TRUE)),
    "sample2" = Rle(sample(0:10, 1000, TRUE)),
    "sample3" = Rle(sample(0:10, 1000, TRUE)),
    "sample4" = Rle(sample(0:10, 1000, TRUE))
)

## Create the model matrices
group <- c("A", "A", "B", "B")
mod.toy <- model.matrix(~group)
mod0.toy <- model.matrix(~ 0 + rep(1, 4))


## Input
test_that("input checks", {
    expect_that(fstats.apply(
        data = toyData, mod = mod.toy, mod0 = mod0.toy,
        scalefac = -1
    ), throws_error())
    expect_that(fstats.apply(
        data = toyData, mod = mod.toy, mod0 = mod0.toy,
        scalefac = 1, method = "mine"
    ), throws_error())
})

## Methods
fstats.Matrix <- fstats.apply(
    data = toyData, mod = mod.toy, mod0 = mod0.toy,
    scalefac = 1, method = "Matrix", adjustF = 0.01
)
fstats.Rle <- fstats.apply(
    data = toyData, mod = mod.toy, mod0 = mod0.toy,
    scalefac = 1, method = "Rle", adjustF = 0.01
)
fstats.regular <- fstats.apply(
    data = toyData, mod = mod.toy, mod0 = mod0.toy,
    scalefac = 1, method = "regular", adjustF = 0.01
)

test_that("methods are equivalent", {
    expect_that(fstats.Matrix, is_identical_to(fstats.Rle))
    expect_that(fstats.regular, is_identical_to(fstats.Rle))
    expect_that(fstats.Matrix, is_identical_to(fstats.regular))
})

## Basic output
vals <- c(0, 0, 2, 0, 3, 1, 1, 0, 1, 3, 4900, 2, 0, 1, 25, 0, 4, 0, 2, 2, 0, 34, 1, 0, 0, 0, 4, 45, 0, 0, 1, 1, 25, 0, 0, 3, 10, 0, 2, 0, 1, 0, 2, 0, 5, 6, 0, 0, 1, 2, 3, 4, 2, 80, 0, 0, 0, 2, 4, 1, 4, 0, 5, 0, 1, 6, 0, 0, 4, 3, 0, 400, 2, 0, 0, 0, 2, 3, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 10, 7, 0, 1, 0, 0, 0, 0, 5, 1, 63, 14, 2, 1, 1, 0, 0, 0, 0, 0, 3, 0, 0, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 16, 18, 1, 5, 0, 4, 0, 0, 3, 0, 1, 2, 4, 0, 0, 0, 6, 900, 0, 0, 0, 10, 2, 0, 4, 0, 1, 1, 1, 0, 0, 16, 2, 0, 0, 0, 1, 0, 0, 0, 0, 9, 0, 10, 0, 1, 0, 1, 0, 20, 400, 9, 0, 0, 1, 0, 1, 0, 1, 2, 9, 34, 0, 0, 4, 16, 0, 6, 0, 1, 0, 1, 10, 1, 1, 8, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 2, 2, 1, 0, 3, 6, 0, 0, 0, 4, 0, 6, 5, 1, 0, 18, 0, 0, 0, 0, 1, 0, 0, 1, 278, 4, 1, 0, 0, 2, 1, 1, 0, 2, 0, 0, 3, 0, 0, 0, 1, 0, 5, 0, 5, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 2, 0, 2, 16, 0, 0, 0, 0, 2, 5, 0, 3, 4, 2, 1, 1, 2, 0, 1, 24, 0, 2, 0, 19, 0, 5, 3, 0, 18, 0, 0, 1, 1, 2, 1, 0, 5, 0, 1, 0, 13, 1, 1, 1, 24, 0, 24, 0, 5, 2, 0, 63, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 71, 1, 0, 1, 4, 0, 16, 1, 2, 1, 0, 2, 1, 3, 1, 3, 1, 4, 0, 2, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 2, 0, 18, 0, 2, 7, 0, 7, 0, 0, 2, 0, 0, 0, 2500, 0, 0, 400, 0, 2, 0, 0, 0, 0, 0, 1, 13, 0, 0, 0, 0, 2, 1, 0, 1, 8, 17, 4, 0, 1, 0, 12, 1, 16, 0, 0, 1, 2, 1, 0, 1, 0, 1, 47, 1, 96, 16, 10, 0, 0, 0, 0, 125, 0, 0, 16, 9, 0, 0, 3, 10, 1, 2, 1, 0, 2, 2, 0, 3, 1, 0, 13, 0, 0, 1, 125, 0, 1, 216, 0, 0, 2, 0, 0, 0, 0, 2, 5, 2, 0, 1, 1, 1, 5, 3, 2, 0, 2, 7, 0, 3, 0, 2, 0, 24, 1, 1, 14, 4, 0, 2, 2, 80, 1, 25, 9, 1, 1, 2, 3, 2, 2, 0, 0, 0, 0, 3, 1, 116, 96, 5, 0, 0, 0, 0, 1, 1, 0, 0, 24, 0, 1, 0, 6, 0, 0, 900, 2, 0, 2, 0, 0, 6, 0, 0, 4, 4, 0, 0, 2, 2, 1, 0, 0, 2, 1, 2, 0, 10, 0, 1, 0, 2, 0, 2, 9, 1, 31, 0, 0, 1, 0, 0, 0, 0, 9, 2, 1, 80, 0, 2, 0, 10, 1, 0, 0, 0, 12, 0, 0, 2, 7, 1, 3, 1, 9, 0, 0, 0, 0, 1, 0, 6, 12, 1, 2, 0, 0, 1, 1, 1, 4, 0, 3, 16, 0, 0, 4, 18, 0, 1, 0, 1, 0, 5, 25, 0, 2, 4, 2, 3, 0, 8, 0, 0, 0, 0, 1, 0, 0, 0, 14, 4, 0, 0, 0, 2, 4, 2, 9, 18, 13, 6, 24, 0, 0, 1, 0, 2, 5, 159, 5, 0, 0, 0, 0, 0, 8, 0, 1, 0, 1, 0, 0, 0, 1, 1, 3, 6, 25, 4, 0, 0, 5, 0, 1, 0, 0, 0, 0, 0, 10, 0, 0, 1, 2, 9, 0, 34, 0, 100, 1, 4, 0, 0, 3, 5, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 2, 0, 1, 0, 0, 1, 3, 1, 49, 0, 2, 0, 80, 1, 0, 0, 0, 0, 0, 0, 0, 4, 71, 1, 0, 0, 0, 1, 0, 0, 2, 0, 0, 25, 4, 0, 0, 4, 0, 78, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 0, 96, 1, 24, 216, 3, 8, 0, 47, 0, 0, 1, 2, 0, 0, 0, 0, 1, 1, 0, 3, 2, 1, 1, 0, 0, 47, 0, 1, 0, 1, 1, 0, 1, 10, 0, 6, 47, 0, 0, 0, 1, 0, 2, 0, 2, 1, 71, 4, 1, 1, 1, 1, 1, 0, 2, 3, 0, 0, 2, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 13, 0, 8, 0, 3, 10, 1, 0, 0, 2, 4, 1, 0, 2, 13, 2, 0, 0, 0, 2, 0, 1, 0, 2, 1, 0, 1, 0, 1, 1, 0, 2, 0, 3, 2, 0, 3, 0, 6, 4, 0, 0, 1, 2, 1, 0, 2, 2, 4, 0, 0, 4, 16, 1, 5, 5, 1, 0, 0, 9, 4, 216, 0, 0, 0, 0, 347, 1, 0, 0, 4, 10, 18, 6, 0, 216, 0, 0, 2, 1, 6, 2, 0, 1, 2, 3, 0, 1, 1, 0, 1, 1, 7, 3, 0, 2, 0, 0, 1, 0, 3, 1, 0, 10, 1, 0, 1, 0, 3, 0, 6, 1, 2, 125, 1, 0, 3, 3, 0, 8, 0, 1, 0, 1, 0, 0, 0, 47, 16, 2, 0, 1, 0, 9, 0, 0, 0, 1, 4, 1, 1, 0, 2, 0, 2, 1, 0, 2, 0, 0, 0, 5, 1, 1, 0, 1, 1, 10, 0, 1, 0, 0, 8100, 3, 0, 0, 2, 0, 0)

lens <- c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
lens <- as.integer(lens)

test_that("Correct output", {
    expect_that(round(runValue(fstats.Matrix)), is_identical_to(vals))
    expect_that(runLength(fstats.Matrix), is_identical_to(lens))
})
