% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{dmmOverlap}
\alias{dmmOverlap}
\alias{dmmOverlap,Demuxmix,missing-method}
\alias{dmmOverlap,Demuxmix,ANY-method}
\title{Calculate the intersection of two components of a mixture model}
\usage{
dmmOverlap(object, hto, tol = 0.001)
}
\arguments{
\item{object}{An object of class \code{\link{Demuxmix}}.}

\item{hto}{Optional vector specifying a subset of HTOs in \code{object} which
should be used by this function.}

\item{tol}{The maximum acceptable error when calculating the
area.}
}
\value{
A numeric vector with the shared probability mass for each HTO in
  the given \code{object}.
}
\description{
\code{dmmOverlap} sums over the probability mass intersected by the two
components of the given mixture model. The sum should be
close to 0 if the HTO labeling experiment was successful.
}
\details{
The probability mass shared between the negative and positive
  component is an informative quality metric for the labeling efficiency
  of the HTO. Values under 0.03 can be considered as good, values larger
  than 0.1 are problematic.
  
  The probability mass functions of the negative and positive component are
  not scaled by the estimated proportions of negative and positive droplets.
  Therefore, the result does not depend on the proportion of cells stained
  with the HTO and the returned value lies between 0 and 1. 
  
  The definition of the shared probability mass is not obvious for a
  regression mixture model since the distributions' means depend on the
  covariate, i.e., the number of detected genes in the RNA library. If a
  regression mixture model is given, this method calculates for each of the
  two components the weighted mean number of detected genes and uses these
  numbers to calculate the expectation value for the negative
  and positive component respectively.
}
\examples{
set.seed(2642)
simdata <- dmmSimulateHto(class = rbind(c(rep(TRUE, 220), rep(FALSE, 200)),
                                        c(rep(FALSE, 200), rep(TRUE, 220))))

dmm <- demuxmix(simdata$hto, model = "naive")
dmmOverlap(dmm)

dmmreg <- demuxmix(simdata$hto, rna = simdata$rna)
dmmOverlap(dmmreg)
dmmOverlap(dmmreg, hto = "HTO_1")
dmmOverlap(dmmreg, hto = 2)

}
\seealso{
\code{\link{demuxmix}}
}
