% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_metrics.R
\name{performanceMeasure}
\alias{performanceMeasure}
\title{Performance metrics to evaluate classification}
\usage{
performanceMeasure(pred, obs, perf.method = "f.measure", ...)
}
\arguments{
\item{pred}{a logical or numeric, where 0 and FALSE represent control, and, 1
and TRUE represent cases}

\item{obs}{a logical or numeric, where 0 and FALSE represent control, and, 1
and TRUE represent cases}

\item{perf.method}{a character, specifying the method to use. Available
methods can be accessed using \code{perfMethods}}

\item{...}{additional parameters to methods. see details}
}
\value{
a numeric, representing the performance
}
\description{
Quantify the performance of a classification algorithm.
  Predictions and truth both have to be binary.
}
\details{
The F-measure requires the beta parameter which can be specified
  using \code{f.beta} which defaults to 1 thereby computing the F1-measure.
}
\examples{
pred <- sample(0:1, 100, replace = TRUE, prob = c(0.75, 0.25))
obs <- sample(0:1, 100, replace = TRUE, prob = c(0.75, 0.25))

#compute the F1 and F2 scores
f1 <- performanceMeasure(pred, obs)
f2 <- performanceMeasure(pred, obs, f.beta = 2)

}
\seealso{
\code{\link{perfMethods}}
}
