% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getContigRegions.R
\name{getContigRegions}
\alias{getContigRegions}
\title{Identifies contiguous regions from a list of nucleotide indices.}
\usage{
getContigRegions(x, gap = 0)
}
\arguments{
\item{x}{A vector of integers.}

\item{gap}{Include gaps in the ranges if they are shorter than or equal to this length.}
}
\value{
IRanges object storing start and end sites of continguous regions.
}
\description{
Given a sequence of nucleotide indices, this function returns integer ranges covered by the indices. There is an option to merge ranges if they are separated by less than a user-specified distance.
}
\examples{
#Convert an integer vector of nucleotide positions to an IRanges object containing the coordinates of contiguous regions.
nucleotide_positions <- c(1, 3, 2, 8, 4:7, 11:20)
getContigRegions(nucleotide_positions)

#Merge regions if their end points are within 3 nt of each other.
getContigRegions(nucleotide_positions, gap = 3)
}
\author{
Krishna Choudhary
}
