% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dStructome.R
\name{dStructome}
\alias{dStructome}
\title{Performs de novo or guided discovery of differentially reactive regions for transcriptome-wide data.}
\usage{
dStructome(
  rl,
  reps_A,
  reps_B,
  batches = FALSE,
  min_length = 11,
  check_signal_strength = TRUE,
  check_nucs = TRUE,
  check_quality = TRUE,
  quality = "auto",
  evidence = 0,
  signal_strength = 0.1,
  within_combs = NULL,
  between_combs = NULL,
  ind_regions = TRUE,
  gap = 1,
  processes = "auto",
  method = "denovo",
  proximity_assisted = FALSE,
  proximity = 10,
  proximity_defined_length = 30
)
}
\arguments{
\item{rl}{List of dataframes of reactivities for each sample.}

\item{reps_A}{Number of replicates of group A.}

\item{reps_B}{Number of replicates of group B.}

\item{batches}{Logical suggesting if replicates of group A and B were performed in batches and are labelled accordingly. If TRUE, a heterogeneous/homogeneous subset may not have multiple samples from the same batch.}

\item{min_length}{Minimum length of constructed regions.}

\item{check_signal_strength}{Logical, if TRUE, construction of regions must be based on nucleotides that have a minimum absolute value of reactivity.}

\item{check_nucs}{Logical, if TRUE, constructed regions must have a minimum number of nucleotides participating in Wilcoxon signed rank test.}

\item{check_quality}{Logical, if TRUE, check constructed regions for quality.}

\item{quality}{Worst allowed quality for a region to be tested.}

\item{evidence}{Minimum evidence of increase in variation from within-group comparisons to between-group comparisons for a region to be tested.}

\item{signal_strength}{Threshold for minimum signal strength.}

\item{within_combs}{Data.frame with each column containing groupings of replicates of groups A or B, which will be used to assess within-group variation.}

\item{between_combs}{Dataframe with each column containing groupings of replicates of groups A and B, which will be used to assess between-group variation.}

\item{ind_regions}{Logical, if TRUE, test each region found in the transcript separately.}

\item{gap}{Integer. Join regions if they are separated by these many nucleotides.}

\item{processes}{Number of parallel processes to use.}

\item{method}{Character specifying either guided or de novo discovery approach.}

\item{proximity_assisted}{Logical, if TRUE, proximally located regions are tested together.}

\item{proximity}{Maximum distance between constructed regions for them to be considered proximal.}

\item{proximity_defined_length}{If performing a "proximity-assisted" test, minimum end-to-end length of a region to be tested.}
}
\value{
Constructs regions, reports p-value and median difference of between-group and within-group d-scores for each region, and FDR for them.
}
\description{
This function provides a convenient way to call the dStruct or
dStructGuided functions for multiple transcripts simultaneously. By default,
the transcripts are processed in using multiple parallel processes if available.
}
\examples{
#Load data from Lai et al., 2019
data(lai2019)

#Run dStruct in de novo discovery mode for all the transcripts in this data in one step.
dStructome(lai2019, 3, 2, batches= TRUE, min_length = 21,
    between_combs = data.frame(c("A3", "B1", "B2")),
    within_combs = data.frame(c("A1", "A2", "A3")),
    ind_regions = TRUE, processes = 1)

#Load data from Wan et al., 2014
data(wan2014)

#Run dStruct in guide discovery mode for all the transcript regions in this data in one step.
dStructome(wan2014, reps_A = 2, reps_B = 1, method = "guided", processes = 1)
}
\references{
Choudhary, K., Lai, Y. H., Tran, E. J., & Aviran, S. (2019).
dStruct: identifying differentially reactive regions from RNA structurome
profiling data. \emph{Genome biology}, 20(1), 1-26.
}
\author{
Krishna Choudhary
}
