% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dStructGuided.R
\name{dStructGuided}
\alias{dStructGuided}
\title{Performs guided discovery of differentially reactive regions.}
\usage{
dStructGuided(
  rdf,
  reps_A,
  reps_B,
  batches = FALSE,
  within_combs = NULL,
  between_combs = NULL,
  check_quality = TRUE,
  quality = "auto",
  evidence = 0
)
}
\arguments{
\item{rdf}{Dataframe of reactivities for each sample. Each column must be labelled as A1, A2, ..., B1, B2, ...}

\item{reps_A}{Number of replicates of group A.}

\item{reps_B}{Number of replicates of group B.}

\item{batches}{Logical suggesting if replicates of group A and B were performed in batches and are labelled accordingly. If TRUE, a heterogeneous/homogeneous subset may not have multiple samples from the same batch.}

\item{within_combs}{Data.frame with each column containing groupings of replicates of groups A or B, which will be used to assess within-group variation.}

\item{between_combs}{Dataframe with each column containing groupings of replicates of groups A and B, which will be used to assess between-group variation.}

\item{check_quality}{Logical, if TRUE, check regions for quality.}

\item{quality}{Worst allowed quality for a region to be tested.}

\item{evidence}{Minimum evidence of increase in variation from within-group comparisons to between-group comparisons for a region to be tested.}
}
\value{
p-value for the tested region (estimated using one-sided Wilcoxon signed rank test) and the median of nucleotide-wise difference of between-group and within-group d-scores.
}
\description{
This function takes as input reactivity profiles for a
transcript region from samples of two groups. First, it regroups the samples
into homogeneous and heteregenous sub-groups, which are used to compute the
within-group and between-group nucleotide-wise \emph{d} scores. If the
region meets the quality criteria, the between- and within-group \emph{d}
scores are compared using the Wilcoxon signed-rank test.
The resulting p-values quantify the significance of difference in reactivity
patterns between the two input groups.
}
\examples{
#Load Wan et al., 2014 data
data(wan2014)

#Run dStruct in the guided mode on first region in wan2014.
dStructGuided(wan2014[[1]], reps_A = 2, reps_B = 1)
}
\references{
Choudhary, K., Lai, Y. H., Tran, E. J., & Aviran, S. (2019).
dStruct: identifying differentially reactive regions from RNA
structurome profiling data. \emph{Genome biology}, 20(1), 1-26.
}
\author{
Krishna Choudhary
}
