% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dStruct.R
\name{dStruct}
\alias{dStruct}
\title{Performs de novo discovery of differentially reactive regions.}
\usage{
dStruct(
  rdf,
  reps_A,
  reps_B,
  batches = FALSE,
  min_length = 11,
  check_signal_strength = TRUE,
  check_nucs = TRUE,
  check_quality = TRUE,
  quality = "auto",
  evidence = 0,
  signal_strength = 0.1,
  within_combs = NULL,
  between_combs = NULL,
  ind_regions = TRUE,
  gap = 1,
  get_FDR = TRUE,
  proximity_assisted = FALSE,
  proximity = 10,
  proximity_defined_length = 30
)
}
\arguments{
\item{rdf}{Dataframe of reactivities for each sample.}

\item{reps_A}{Number of replicates of group A.}

\item{reps_B}{Number of replicates of group B.}

\item{batches}{Logical suggesting if replicates of group A and B were performed in batches and are labelled accordingly. If TRUE, a heterogeneous/homogeneous subset may not have multiple samples from the same batch.}

\item{min_length}{Minimum length of constructed regions.}

\item{check_signal_strength}{Logical, if TRUE, construction of regions must be based on nucleotides that have a minimum absolute value of reactivity.}

\item{check_nucs}{Logical, if TRUE, constructed regions must have a minimum number of nucleotides participating in Wilcoxon signed rank test.}

\item{check_quality}{Logical, if TRUE, check constructed regions for quality.}

\item{quality}{Worst allowed quality for a region to be tested.}

\item{evidence}{Minimum evidence of increase in variation from within-group comparisons to between-group comparisons for a region to be tested.}

\item{signal_strength}{Threshold for minimum signal strength.}

\item{within_combs}{Data.frame with each column containing groupings of replicates of groups A or B, which will be used to assess within-group variation.}

\item{between_combs}{Dataframe with each column containing groupings of replicates of groups A and B, which will be used to assess between-group variation.}

\item{ind_regions}{Logical, if TRUE, test each region found in the transcript separately.}

\item{gap}{Integer. Join regions if they are separated by these many nucleotides.}

\item{get_FDR}{Logical, if FALSE, FDR is not reported.}

\item{proximity_assisted}{Logical, if TRUE, proximally located regions are tested together.}

\item{proximity}{Maximum distance between constructed regions for them to be considered proximal.}

\item{proximity_defined_length}{If performing a "proximity-assisted" test, minimum end-to-end length of a region to be tested.}
}
\value{
Constructs regions, reports p-value and median difference of between-group and within-group d-scores for each region, and FDR for them.
}
\description{
This function takes reactivity profiles for samples of two groups
as input and identifies differentially reactive regions in three steps (see
Choudhary et al., \emph{Genome Biology}, 2019 for details). First, it regroups
the samples into homogeneous and heteregenous sub-groups, which are used to
compute the within-group and between-group nucleotide-wise \emph{d} scores.
Second, smoothed between- and within-group \emph{d} score profiles are compared
to construct candidate differential regions. Finally, unsmoothed between- and
within-group \emph{d} scores are compared using the Wilcoxon signed-rank test.
The resulting p-values quantify the significance of difference in reactivity
patterns between the two input groups.
}
\examples{
#Load data from Lai et al., 2019
data(lai2019)

#Run dStruct in de novo discovery mode for a transcript with id YAL042W.
dStruct(rdf = lai2019[["YAL042W"]], reps_A = 3, reps_B = 2,
    batches = TRUE, min_length = 21,
    between_combs = data.frame(c("A3", "B1", "B2")),
    within_combs = data.frame(c("A1", "A2", "A3")),
    ind_regions = TRUE)
}
\references{
Choudhary, K., Lai, Y. H., Tran, E. J., & Aviran, S. (2019).
dStruct: identifying differentially reactive regions from RNA structurome
profiling data. \emph{Genome biology}, 20(1), 1-26.
}
\author{
Krishna Choudhary
}
