#' @title \emph{Saccharomyces cerevisiae} Structure-seq data
#'
#' @description Data from a Structure-seq assay of five samples of \emph{S. cerevisiae}, three
#' of which were wild-type samples and two mutant samples. The data was
#' pre-processed to obtain DMS reactivities as described by Lai et al. (2019).
#'
#' @docType data
#'
#' @usage data("lai2019")
#'
#' @format An object of class \code{"list"}.
#'
#' @keywords datasets
#'
#' @references Lai et al. (2019) Genetics, Vol. 212, 153–174
#' (\href{https://doi.org/10.1534/genetics.119.302058}{Genetics})
#'
#' @source Raw data from \href{https://doi.org/10.1534/genetics.119.302058}{Lai et al., 2019} in processed form.
#'
#' @examples
#' data("lai2019")
"lai2019"

#' @title \emph{Homo sapiens} PARS data
#'
#' @description Data from a PARS assay of a family trio of mother, father, and child. The
#' data was pre-processed to obtain PARS scores as described in Choudhary et al. (2019).
#'
#' @docType data
#'
#' @usage data(wan2014)
#'
#' @format An object of class \code{"list"}.
#'
#' @keywords datasets
#'
#' @references Wan et al., Nature, 505, 706–709 (2014)
#' (\href{https://doi.org/10.1038/nature12946}{Nature})
#'
#' @source Counts data from \href{https://doi.org/10.1038/nature12946}{Wan et al., 2014} in processed form.
#'
#' @examples
#' data(wan2014)
"wan2014"
