% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newFlowframe.R
\name{newFlowframe}
\alias{newFlowframe}
\title{takes a flowframe, a group indicator and formulates another flowframe with 
group indicator as part of the
expression matrix of the new flowframe.}
\usage{
newFlowframe(flowfile, group = NULL, togate = NULL)
}
\arguments{
\item{flowfile}{flowframe after debris are removed.}

\item{group}{cluster group to be added to the expression matrix}

\item{togate}{channel detected to have more than one peak}
}
\value{
flowframe with indicators for particle cluster
}
\description{
takes a flowframe, a group indicator and formulates another flowframe with 
group indicator as part of the
expression matrix of the new flowframe.
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                  package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
c('SSC.W', 'TIME'))
oneDgate(flowfile, 'RED.B.HLin')

}
